/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.wordcount.SimpleWordCountStep;
import net.sf.okapi.steps.wordcount.WordCounter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestSimpleWordCountStep {
    @Test
    public void testTextUnitCounts() {
        SimpleWordCountStep step = new SimpleWordCountStep();
        step.setSourceLocale(LocaleId.ENGLISH);
        StartDocument sd = new StartDocument("sd");
        sd.setLocale(LocaleId.ENGLISH);
        step.handleEvent(new Event(EventType.START_DOCUMENT, (IResource)sd));
        TextUnit tu = new TextUnit("tu");
        TextContainer tc = tu.getSource();
        ISegments segments = tc.getSegments();
        segments.append(new TextFragment("The number of words in this segment is 9."));
        segments.append(new TextFragment("The number of words in this second segment is 10."));
        segments.append(new TextFragment("And the number of words in this third segment is 11."));
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)30L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
        tu.setSourceContent(new TextFragment(""));
        tu.getSource().getAnnotations().clear();
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)0L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
        tu.setSourceContent(new TextFragment("..."));
        tu.getSource().getAnnotations().clear();
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)0L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
        tu.setSourceContent(new TextFragment("Joe Pickett."));
        tu.getSource().getAnnotations().clear();
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)2L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
        tu.setSourceContent(new TextFragment("Joe Pickett"));
        tu.getSource().getAnnotations().clear();
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)2L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
        tu.setSourceContent(new TextFragment("123 456 789"));
        tu.getSource().getAnnotations().clear();
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)3L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
        tu.setSourceContent(new TextFragment("The quick (\\\"brown\\\") fox can jump 32 feet, right?"));
        tu.getSource().getAnnotations().clear();
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)9L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
        tu.setSourceContent(new TextFragment("The quick (\\\"brown\\\") fox can't jump 32.2 feet, right?"));
        tu.getSource().getAnnotations().clear();
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)9L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
        tu.setSourceContent(new TextFragment("Born in the U.S.A"));
        tu.getSource().getAnnotations().clear();
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)4L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
        tu.setSourceContent(new TextFragment("Alpha/Beta\\Gamma"));
        tu.getSource().getAnnotations().clear();
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)3L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
    }

    @Test
    public void testTextUnitCountsFrench() {
        SimpleWordCountStep step = new SimpleWordCountStep();
        step.setSourceLocale(LocaleId.FRENCH);
        StartDocument sd = new StartDocument("sd");
        sd.setLocale(LocaleId.FRENCH);
        step.handleEvent(new Event(EventType.START_DOCUMENT, (IResource)sd));
        TextUnit tu = new TextUnit("tu");
        tu.setSourceContent(new TextFragment("L'objectif est defini"));
        tu.getSource().getAnnotations().clear();
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)3L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
        tu.setSourceContent(new TextFragment("Elle a \u00e9t\u00e9 la premi\u00e8re Fran\u00e7aise d\u2019une famille d\u2019\u00e9migr\u00e9s."));
        tu.getSource().getAnnotations().clear();
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)9L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
    }
}

