/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.steps.wordcount.WordCounter;
import net.sf.okapi.steps.wordcount.common.GMX;
import net.sf.okapi.steps.wordcount.common.Parameters;
import net.sf.okapi.steps.wordcount.common.TokenCountStep;

@UsingParameters(value=Parameters.class)
public class WordCountStep
extends TokenCountStep {
    public static final String METRIC = "TotalWordCount";

    @Override
    public String getMetric() {
        return METRIC;
    }

    @Override
    protected String[] getTokenNames() {
        return new String[]{WordCounter.getTokenName()};
    }

    @Override
    protected boolean countOnlyTranslatable() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Count the number of words in the text units of a set of documents or/and in its parts. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Word Count";
    }

    @Override
    protected long count(Segment segment, LocaleId locale) {
        if (GMX.isLogographicScript(locale)) {
            return WordCounter.countLogographicScript(segment, locale);
        }
        return super.count(segment, locale);
    }

    @Override
    protected long count(TextContainer textContainer, LocaleId locale) {
        if (GMX.isLogographicScript(locale)) {
            return WordCounter.countLogographicScript(textContainer, locale);
        }
        return super.count(textContainer, locale);
    }
}

