/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;

public class SimpleWordCountStep
extends BasePipelineStep {
    private RuleBasedBreakIterator srcWordIterator = null;
    private LocaleId srcLoc;
    private long srcBatchItemWordCount;
    private long srcBatchWordCount;

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.srcLoc = sourceLocale;
        this.srcWordIterator = (RuleBasedBreakIterator)BreakIterator.getWordInstance((ULocale)ULocale.createCanonical((String)this.srcLoc.toString()));
        RuleBasedBreakIterator.registerInstance((BreakIterator)this.srcWordIterator, (Locale)this.srcLoc.toJavaLocale(), (int)1);
    }

    protected Event handleStartBatch(Event event) {
        this.srcBatchWordCount = 0L;
        return super.handleStartBatch(event);
    }

    protected Event handleStartBatchItem(Event event) {
        this.srcBatchItemWordCount = 0L;
        return super.handleStartBatchItem(event);
    }

    protected Event handleEndBatchItem(Event event) {
        MetricsAnnotation sma;
        Ending res = event.getEnding();
        if (res == null) {
            res = new Ending("");
            event.setResource((IResource)res);
        }
        if ((sma = (MetricsAnnotation)res.getAnnotation(MetricsAnnotation.class)) == null) {
            sma = new MetricsAnnotation();
            res.setAnnotation((IAnnotation)sma);
        }
        Metrics m = sma.getMetrics();
        m.setMetric("TotalWordCount", this.srcBatchItemWordCount);
        this.srcBatchWordCount += this.srcBatchItemWordCount;
        return super.handleEndBatchItem(event);
    }

    protected Event handleEndBatch(Event event) {
        MetricsAnnotation sma;
        Ending res = event.getEnding();
        if (res == null) {
            res = new Ending("");
            event.setResource((IResource)res);
        }
        if ((sma = (MetricsAnnotation)res.getAnnotation(MetricsAnnotation.class)) == null) {
            sma = new MetricsAnnotation();
            res.setAnnotation((IAnnotation)sma);
        }
        Metrics m = sma.getMetrics();
        m.setMetric("TotalWordCount", this.srcBatchWordCount);
        return super.handleEndBatch(event);
    }

    protected Event handleTextUnit(Event event) {
        MetricsAnnotation sma;
        ITextUnit tu = event.getTextUnit();
        long srcWordCount = 0L;
        if (tu.isEmpty() || !tu.isTranslatable()) {
            return event;
        }
        if (!tu.getSource().isEmpty()) {
            srcWordCount = this.countWords(tu.getSource().getUnSegmentedContentCopy().getText());
            this.srcBatchItemWordCount += srcWordCount;
        }
        if ((sma = (MetricsAnnotation)tu.getSource().getAnnotation(MetricsAnnotation.class)) == null) {
            sma = new MetricsAnnotation();
            tu.getSource().setAnnotation((IAnnotation)sma);
        }
        Metrics m = sma.getMetrics();
        m.setMetric("TotalWordCount", srcWordCount);
        return event;
    }

    public String getName() {
        return "Simple Word Count";
    }

    public String getDescription() {
        return "Annotates each text unit source with a total word count and gives total source word counts for batches Expects: filter events. Sends back: filter events.";
    }

    public IParameters getParameters() {
        return null;
    }

    public void setParameters(IParameters params) {
    }

    private long countWords(String text) {
        long totalWordCount = 0L;
        int current = 0;
        if (Util.isEmpty((String)text)) {
            return totalWordCount;
        }
        RuleBasedBreakIterator wordIterator = this.srcWordIterator;
        wordIterator.setText(text);
        while (current != -1) {
            current = wordIterator.next();
            if (wordIterator.getRuleStatus() == 0) continue;
            ++totalWordCount;
        }
        return totalWordCount;
    }
}

