/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import java.text.Normalizer;
import java.util.Objects;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.steps.wordcount.common.BaseCounter;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;

public class CharacterCounter
extends BaseCounter {
    private static final CharacterCounter counter = new CharacterCounter();

    public Counts doFullCount(Object text, LocaleId language) {
        if (text == null) {
            return new Counts();
        }
        if (Util.isNullOrEmpty((LocaleId)language)) {
            return new Counts();
        }
        if (text instanceof ITextUnit) {
            ITextUnit tu = (ITextUnit)text;
            return this.doFullCount(tu.getSource(), language);
        }
        if (text instanceof Segment) {
            Segment seg = (Segment)text;
            return this.doFullCount(seg.getContent(), language);
        }
        if (text instanceof TextContainer) {
            TextContainer tc = (TextContainer)text;
            Counts res = new Counts();
            for (Segment seg : tc.getSegments()) {
                res = res.add(this.doFullCount(seg, language));
            }
            return res;
        }
        if (text instanceof TextFragment) {
            TextFragment tf = (TextFragment)text;
            return this.doFullCount(TextUnitUtil.getText((TextFragment)tf), language);
        }
        if (text instanceof String) {
            return this.doFullCountImpl((String)text, language);
        }
        return new Counts();
    }

    @Override
    protected long doCountImpl(String text, LocaleId language) {
        if (text == null) {
            return 0L;
        }
        return this.doFullCount((Object)text, (LocaleId)language).total;
    }

    protected Counts doFullCountImpl(String text, LocaleId language) {
        int cc;
        if (text == null) {
            return new Counts();
        }
        if (!Normalizer.isNormalized(text, Normalizer.Form.NFC)) {
            text = Normalizer.normalize(text, Normalizer.Form.NFC);
        }
        long total = 0L;
        long whiteSpace = 0L;
        long punctuation = 0L;
        int len = text.length();
        for (int i = 0; i < len; i += cc) {
            int cp = text.codePointAt(i);
            cc = Character.charCount(cp);
            if (Character.isWhitespace(cp)) {
                ++whiteSpace;
                continue;
            }
            boolean isInWord = false;
            if (i > 0 && i < len - cc) {
                int prev = text.codePointBefore(i);
                int next = text.codePointAt(i + cc);
                boolean bl = isInWord = Character.isLetterOrDigit(prev) && Character.isLetterOrDigit(next);
            }
            if (CharacterCounter.isPunctuation(cp) && (!isInWord || !CharacterCounter.isHyphen(cp) && !CharacterCounter.isApostrophe(cp))) {
                ++punctuation;
                continue;
            }
            ++total;
        }
        return new Counts(total, whiteSpace, punctuation);
    }

    private static boolean isApostrophe(int codePoint) {
        return codePoint == 39 || codePoint == 8217;
    }

    private static boolean isHyphen(int codePoint) {
        return codePoint == 45 || codePoint == 8208 || codePoint == 1418 || codePoint == 12448;
    }

    private static boolean isPunctuation(int codePoint) {
        return codePoint >= 33 && codePoint <= 47 || codePoint >= 58 && codePoint <= 64 || codePoint >= 91 && codePoint <= 96 || codePoint >= 123 && codePoint <= 126 || codePoint >= 8192 && codePoint <= 8303 || codePoint >= 12288 && codePoint <= 12351 || "\u00f7\u00d7\u00a1\u00bf\u0589\u05c3\u05be\u05c0\u061b".indexOf(codePoint) != -1;
    }

    public static void setCount(IWithAnnotations res, long count) {
        MetricsAnnotation ma = (MetricsAnnotation)res.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            res.setAnnotation((IAnnotation)ma);
        }
        Metrics m = ma.getMetrics();
        m.setMetric("TotalCharacterCount", count);
    }

    @Override
    protected String getMetricNameForRetrieval() {
        return "TotalCharacterCount";
    }

    public static long count(Object text, LocaleId language) {
        return counter.doCount(text, language);
    }

    public static Counts fullCount(Object text, LocaleId language) {
        return counter.doFullCount(text, language);
    }

    public static long getCount(ITextUnit tu) {
        return counter.doGetCount((IWithAnnotations)tu);
    }

    public static long getCount(ITextUnit tu, int segIndex) {
        ISegments segments = tu.getSource().getSegments();
        return CharacterCounter.getCount(segments.get(segIndex));
    }

    public static long getCount(Segment segment) {
        return counter.doGetCount(segment);
    }

    public static class Counts {
        public final long total;
        public final long whiteSpace;
        public final long punctuation;

        public static Counts of(long total, long whiteSpace, long punctuation) {
            return new Counts(total, whiteSpace, punctuation);
        }

        public Counts() {
            this.total = 0L;
            this.whiteSpace = 0L;
            this.punctuation = 0L;
        }

        public Counts(long total, long whiteSpace, long punctuation) {
            this.total = total;
            this.whiteSpace = whiteSpace;
            this.punctuation = punctuation;
        }

        public Counts add(Counts other) {
            return new Counts(this.total + other.total, this.whiteSpace + other.whiteSpace, this.punctuation + other.punctuation);
        }

        public boolean isAllZeros() {
            return this.total == 0L && this.whiteSpace == 0L && this.punctuation == 0L;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Counts o = (Counts)obj;
            return this.total == o.total && this.whiteSpace == o.whiteSpace && this.punctuation == o.punctuation;
        }

        public int hashCode() {
            return Objects.hash(this.total, this.whiteSpace, this.punctuation);
        }

        public String toString() {
            return String.format("%d total, %d whitespace, %d punctuation", this.total, this.whiteSpace, this.punctuation);
        }
    }
}

