/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.steps.wordcount.WordCounter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestWordCount {
    private LocaleId locEN = LocaleId.ENGLISH;
    private LocaleId locFR = LocaleId.FRENCH;
    private LocaleId locES005 = LocaleId.fromString((String)"es-005");

    @Test
    public void testStatics() {
        Assert.assertEquals((long)5L, (long)WordCounter.count((String)"Test word count is correct.", (LocaleId)this.locEN));
        Assert.assertEquals((long)9L, (long)WordCounter.count((String)"The quick (\"brown\") fox can't jump 32.3 feet, right?", (LocaleId)this.locEN));
        Assert.assertEquals((long)9L, (long)WordCounter.count((String)"The quick (\u201cbrown\u201d) fox can\u2019t jump 32.3 feet, right?", (LocaleId)this.locEN));
        Assert.assertEquals((long)4L, (long)WordCounter.count((String)"Words in a sentence", (LocaleId)this.locEN));
        Assert.assertEquals((long)4L, (long)WordCounter.count((String)"Words in a sentence", (LocaleId)this.locES005));
    }

    @Test
    public void testCountApostrophe() {
        Assert.assertEquals((long)4L, (long)WordCounter.count((String)"L'objectif est defini.", (LocaleId)this.locFR));
        Assert.assertEquals((long)4L, (long)WordCounter.count((String)"L\u2019objectif est defini.", (LocaleId)this.locFR));
        Assert.assertEquals((long)11L, (long)WordCounter.count((String)"Elle a \u00e9t\u00e9 la premi\u00e8re Fran\u00e7aise d'une famille d'\u00e9migr\u00e9s.", (LocaleId)this.locFR));
        Assert.assertEquals((long)11L, (long)WordCounter.count((String)"Elle a \u00e9t\u00e9 la premi\u00e8re Fran\u00e7aise d\u2019une famille d\u2019\u00e9migr\u00e9s.", (LocaleId)this.locFR));
        Assert.assertEquals((long)5L, (long)WordCounter.count((String)"He can't eat that fast.", (LocaleId)this.locEN));
        Assert.assertEquals((long)5L, (long)WordCounter.count((String)"He can\u2019t eat that fast.", (LocaleId)this.locEN));
    }

    @Test
    public void testCountHyphen() {
        Assert.assertEquals((long)5L, (long)WordCounter.count((String)"  Al Capone was an Italian-American.  ", (LocaleId)this.locEN));
    }

    @Test
    public void testCountGMXExamples() {
        Assert.assertEquals((long)9L, (long)WordCounter.count((String)"This sentence has a word count of 9 words.", (LocaleId)this.locEN));
        Assert.assertEquals((long)11L, (long)WordCounter.count((String)"This sentence/text unit has a word count of 11 words.", (LocaleId)this.locEN));
    }

    @Test
    public void testCountTokens() {
        Assert.assertEquals((long)3L, (long)WordCounter.count((String)"123 123.4 123,5", (LocaleId)this.locEN));
        Assert.assertEquals((long)0L, (long)WordCounter.count((String)"( ) \" ' { } [ ] / % $ @ # ? ! * _ -", (LocaleId)this.locEN));
    }

    @Test
    public void testCountEmpty() {
        Assert.assertEquals((long)0L, (long)WordCounter.count((String)"", (LocaleId)this.locEN));
        Assert.assertEquals((long)0L, (long)WordCounter.count((String)" \t\n\f\r ", (LocaleId)this.locEN));
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "b", "[b]");
        Assert.assertEquals((long)0L, (long)WordCounter.count((TextFragment)tf, (LocaleId)this.locEN));
    }

    @Test
    public void testCountFragments() {
        TextFragment tf = new TextFragment("abc");
        tf.append(TextFragment.TagType.PLACEHOLDER, "b", "[b]");
        tf.append("def");
        Assert.assertEquals((long)1L, (long)WordCounter.count((TextFragment)tf, (LocaleId)this.locEN));
    }

    @Test
    public void testCharCountFactorLanguages() {
        Assert.assertEquals((long)1L, (long)WordCounter.count((String)"\u65e5\u672c\u8a9e", (LocaleId)LocaleId.JAPANESE));
        Assert.assertEquals((long)1L, (long)WordCounter.count((String)"\ud55c\uad6d\uc5b4", (LocaleId)LocaleId.KOREAN));
        Assert.assertEquals((long)1L, (long)WordCounter.count((String)"\u4f60\u597d\u5417", (LocaleId)LocaleId.CHINA_CHINESE));
        Assert.assertEquals((long)1L, (long)WordCounter.count((String)"\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22", (LocaleId)LocaleId.fromString((String)"th")));
        Assert.assertEquals((long)0L, (long)WordCounter.count((String)"\u0e9e\u0eb2\u0eaa\u0eb2\u0ea5\u0eb2\u0ea7", (LocaleId)LocaleId.fromString((String)"lo")));
        Assert.assertEquals((long)0L, (long)WordCounter.count((String)"\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a", (LocaleId)LocaleId.fromString((String)"km")));
        Assert.assertEquals((long)0L, (long)WordCounter.count((String)"\u1019\u103c\u1014\u103a\u1019\u102c\u1018\u102c\u101e\u102c", (LocaleId)LocaleId.fromString((String)"my")));
        try {
            WordCounter.countLogographicScript((Object)"Hello", (LocaleId)LocaleId.ENGLISH);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

