/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.wordcount.WordCountStep;
import net.sf.okapi.steps.wordcount.WordCounter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestWordCountStep {
    @Test
    public void testTextUnitCounts() {
        this.testTextUnitCounts(LocaleId.ENGLISH, new String[]{"The number of words in this segment is 9.", "The number of words in this second segment is 10.", "And the number of words in this third segment is 11."}, new long[]{9L, 10L, 11L, 30L});
    }

    @Test
    public void testTextUnitCountsCharFactor() {
        this.testTextUnitCounts(LocaleId.JAPANESE, new String[]{"\u65e5\u672c\u8a9e", "\u65e5\u672c\u8a9e\u65e5\u672c\u8a9e", "\u65e5\u672c\u8a9e\u65e5\u672c\u8a9e\u65e5\u672c\u8a9e"}, new long[]{1L, 2L, 3L, 6L});
        this.testTextUnitCounts(LocaleId.KOREAN, new String[]{"\ud55c\uad6d\uc5b4", "\ud55c\uad6d\uc5b4\ud55c\uad6d\uc5b4", "\ud55c\uad6d\uc5b4\ud55c\uad6d\uc5b4\ud55c\uad6d\uc5b4"}, new long[]{1L, 2L, 3L, 5L});
        this.testTextUnitCounts(LocaleId.CHINA_CHINESE, new String[]{"\u4f60\u597d\u5417", "\u4f60\u597d\u5417\u4f60\u597d\u5417", "\u4f60\u597d\u5417\u4f60\u597d\u5417\u4f60\u597d\u5417"}, new long[]{1L, 2L, 3L, 6L});
        this.testTextUnitCounts(LocaleId.fromString((String)"th"), new String[]{"\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22", "\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22", "\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22"}, new long[]{1L, 2L, 4L, 7L});
        this.testTextUnitCounts(LocaleId.fromString((String)"lo"), new String[]{"\u0e9e\u0eb2\u0eaa\u0eb2\u0ea5\u0eb2\u0ea7", "\u0e9e\u0eb2\u0eaa\u0eb2\u0ea5\u0eb2\u0ea7\u0e9e\u0eb2\u0eaa\u0eb2\u0ea5\u0eb2\u0ea7", "\u0e9e\u0eb2\u0eaa\u0eb2\u0ea5\u0eb2\u0ea7\u0e9e\u0eb2\u0eaa\u0eb2\u0ea5\u0eb2\u0ea7\u0e9e\u0eb2\u0eaa\u0eb2\u0ea5\u0eb2\u0ea7"}, new long[]{0L, 0L, 0L, 0L});
        this.testTextUnitCounts(LocaleId.fromString((String)"km"), new String[]{"\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a", "\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a", "\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a"}, new long[]{0L, 0L, 0L, 0L});
        this.testTextUnitCounts(LocaleId.fromString((String)"my"), new String[]{"\u1019\u103c\u1014\u103a\u1019\u102c\u1018\u102c\u101e\u102c", "\u1019\u103c\u1014\u103a\u1019\u102c\u1018\u102c\u101e\u102c\u1019\u103c\u1014\u103a\u1019\u102c\u1018\u102c\u101e\u102c", "\u1019\u103c\u1014\u103a\u1019\u102c\u1018\u102c\u101e\u102c\u1019\u103c\u1014\u103a\u1019\u102c\u1018\u102c\u101e\u102c\u1019\u103c\u1014\u103a\u1019\u102c\u1018\u102c\u101e\u102c"}, new long[]{0L, 0L, 0L, 0L});
    }

    private void testTextUnitCounts(LocaleId locale, String[] frags, long[] counts) {
        TextUnit tu = new TextUnit("tu");
        TextContainer tc = tu.getSource();
        ISegments segments = tc.getSegments();
        segments.append(new TextFragment(frags[0]));
        segments.append(new TextFragment(frags[1]));
        segments.append(new TextFragment(frags[2]));
        WordCountStep step = new WordCountStep();
        StartDocument sd = new StartDocument("sd");
        sd.setLocale(locale);
        step.handleEvent(new Event(EventType.START_DOCUMENT, (IResource)sd));
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)counts[0], (long)WordCounter.getCount((ITextUnit)tu, (int)0));
        Assert.assertEquals((long)counts[1], (long)WordCounter.getCount((ITextUnit)tu, (int)1));
        Assert.assertEquals((long)counts[2], (long)WordCounter.getCount((ITextUnit)tu, (int)2));
        Assert.assertEquals((long)counts[3], (long)WordCounter.getCount((ITextUnit)tu));
    }
}

