/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.wordcount.SimpleWordCountStep;
import net.sf.okapi.steps.wordcount.WordCounter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestSimpleWordCountStep {
    @Test
    public void testTextUnitCounts() {
        TextUnit tu = new TextUnit("tu");
        TextContainer tc = tu.getSource();
        ISegments segments = tc.getSegments();
        segments.append(new TextFragment("The number of words in this segment is 9."));
        segments.append(new TextFragment("The number of words in this second segment is 10."));
        segments.append(new TextFragment("And the number of words in this third segment is 11."));
        SimpleWordCountStep step = new SimpleWordCountStep();
        step.setSourceLocale(LocaleId.ENGLISH);
        StartDocument sd = new StartDocument("sd");
        sd.setLocale(LocaleId.ENGLISH);
        step.handleEvent(new Event(EventType.START_DOCUMENT, (IResource)sd));
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)30L, (long)WordCounter.getCount((TextContainer)tu.getSource()));
    }
}

