/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.wordcount.CharacterCountStep;
import net.sf.okapi.steps.wordcount.CharacterCounter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestCharacterCountStep {
    @Test
    public void testTextUnitCounts() {
        TextUnit tu = new TextUnit("tu");
        TextContainer tc = tu.getSource();
        ISegments segments = tc.getSegments();
        segments.append(new TextFragment("The number of characters in this segment is 38."));
        segments.append(new TextFragment("The number of characters in this second segment is 44."));
        segments.append(new TextFragment("And the number of characters in this third segment is 46."));
        CharacterCountStep step = new CharacterCountStep();
        StartDocument sd = new StartDocument("sd");
        sd.setLocale(LocaleId.ENGLISH);
        step.handleEvent(new Event(EventType.START_DOCUMENT, (IResource)sd));
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)tu));
        Assert.assertEquals((long)38L, (long)CharacterCounter.getCount((ITextUnit)tu, (int)0));
        Assert.assertEquals((long)44L, (long)CharacterCounter.getCount((ITextUnit)tu, (int)1));
        Assert.assertEquals((long)46L, (long)CharacterCounter.getCount((ITextUnit)tu, (int)2));
        Assert.assertEquals((long)128L, (long)CharacterCounter.getCount((ITextUnit)tu));
    }
}

