/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.whitespacecorrection;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.whitespacecorrection.PunctuationConversionStep;
import net.sf.okapi.steps.whitespacecorrection.WhitespaceCorrector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WhitespaceCorrectorTest {
    @Test
    public void testSpaceDelimitedLanguage() {
        Assert.assertTrue((boolean)WhitespaceCorrector.isSpaceDelimitedLanguage((LocaleId)LocaleId.ENGLISH));
        Assert.assertTrue((boolean)WhitespaceCorrector.isSpaceDelimitedLanguage((LocaleId)LocaleId.FRENCH));
        Assert.assertFalse((boolean)WhitespaceCorrector.isSpaceDelimitedLanguage((LocaleId)LocaleId.JAPANESE));
        Assert.assertFalse((boolean)WhitespaceCorrector.isSpaceDelimitedLanguage((LocaleId)LocaleId.CHINA_CHINESE));
    }

    @Test
    public void testEnglishToJapanese() {
        WhitespaceCorrector corrector = new WhitespaceCorrector(LocaleId.ENGLISH, LocaleId.JAPANESE, Collections.singleton(WhitespaceCorrector.Punctuation.FULL_STOP), (Set)WhitespaceCorrector.ALL_WHITESPACE);
        TextUnit tu = this.makeTuTarget(this.makeTu("Sentence 1.  ", "Sentence 2. ", "Sentence 3.  Sentence 4."), LocaleId.JAPANESE, new PunctuationConversionStep.En2JaTranslator());
        TextContainer tgtTc = tu.getTarget(LocaleId.JAPANESE);
        List parts = tgtTc.getParts();
        Assert.assertEquals((Object)"Sentence 1\u3002  ", (Object)((TextPart)parts.get(0)).toString());
        Assert.assertEquals((Object)"Sentence 2\u3002 ", (Object)((TextPart)parts.get(1)).toString());
        Assert.assertEquals((Object)"Sentence 3\u3002  Sentence 4\u3002", (Object)((TextPart)parts.get(2)).toString());
        tu = corrector.correctWhitespace((ITextUnit)tu);
        Assert.assertEquals((Object)"Sentence 1\u3002Sentence 2\u3002Sentence 3\u3002Sentence 4\u3002", (Object)tu.getTarget(LocaleId.JAPANESE).toString());
    }

    @Test
    public void testEnglishToJapaneseWhitespaceOnly() {
        WhitespaceCorrector corrector = new WhitespaceCorrector(LocaleId.ENGLISH, LocaleId.JAPANESE, Collections.singleton(WhitespaceCorrector.Punctuation.FULL_STOP), (Set)WhitespaceCorrector.SPACE);
        TextUnit tu = this.makeTuTarget(this.makeTu("Sentence 1.  ", "Sentence 2. ", "Sentence 3.  Sentence 4."), LocaleId.JAPANESE, new PunctuationConversionStep.En2JaTranslator());
        TextContainer tgtTc = tu.getTarget(LocaleId.JAPANESE);
        List parts = tgtTc.getParts();
        Assert.assertEquals((Object)"Sentence 1\u3002  ", (Object)((TextPart)parts.get(0)).toString());
        Assert.assertEquals((Object)"Sentence 2\u3002 ", (Object)((TextPart)parts.get(1)).toString());
        Assert.assertEquals((Object)"Sentence 3\u3002  Sentence 4\u3002", (Object)((TextPart)parts.get(2)).toString());
        tu = corrector.correctWhitespace((ITextUnit)tu);
        Assert.assertEquals((Object)"Sentence 1\u3002Sentence 2\u3002Sentence 3\u3002Sentence 4\u3002", (Object)tu.getTarget(LocaleId.JAPANESE).toString());
    }

    @Test
    public void testJapaneseToEnglish() {
        WhitespaceCorrector corrector = new WhitespaceCorrector(LocaleId.JAPANESE, LocaleId.ENGLISH, Collections.singleton(WhitespaceCorrector.Punctuation.FULL_STOP), (Set)WhitespaceCorrector.ALL_WHITESPACE);
        TextUnit tu = this.makeTuTarget(this.makeTu("Sentence 1\u3002", "Sentence 2\uff0e", "Sentence 3\u3002Sentence 4\u3002"), LocaleId.ENGLISH, new PunctuationConversionStep.Ja2EnTranslator());
        TextContainer tgtTc = tu.getTarget(LocaleId.ENGLISH);
        List parts = tgtTc.getParts();
        Assert.assertEquals((Object)"Sentence 1.", (Object)((TextPart)parts.get(0)).toString());
        Assert.assertEquals((Object)"Sentence 2.", (Object)((TextPart)parts.get(1)).toString());
        Assert.assertEquals((Object)"Sentence 3.Sentence 4.", (Object)((TextPart)parts.get(2)).toString());
        tu = corrector.correctWhitespace((ITextUnit)tu);
        Assert.assertEquals((Object)"Sentence 1. Sentence 2. Sentence 3.Sentence 4. ", (Object)tu.getTarget(LocaleId.ENGLISH).toString());
    }

    @Test
    public void testAdditionalPunctuationToJapanese() {
        WhitespaceCorrector corrector = new WhitespaceCorrector(LocaleId.ENGLISH, LocaleId.JAPANESE, new HashSet<WhitespaceCorrector.Punctuation>(Arrays.asList(WhitespaceCorrector.Punctuation.values())), (Set)WhitespaceCorrector.ALL_WHITESPACE);
        TextUnit tu = this.makeTuTarget(this.makeTu("Sentence 1?  ", "Sentence 2!\n", "Sentence 3,\t"), LocaleId.JAPANESE, new PunctuationConversionStep.En2JaTranslator());
        tu = corrector.correctWhitespace((ITextUnit)tu);
        Assert.assertEquals((Object)"Sentence 1\uff1fSentence 2\uff01Sentence 3\u3001", (Object)tu.getTarget(LocaleId.JAPANESE).toString());
    }

    @Test
    public void testAdditionalPunctuationToEnglish() {
        WhitespaceCorrector corrector = new WhitespaceCorrector(LocaleId.JAPANESE, LocaleId.ENGLISH, new HashSet<WhitespaceCorrector.Punctuation>(Arrays.asList(WhitespaceCorrector.Punctuation.values())), (Set)WhitespaceCorrector.ALL_WHITESPACE);
        TextUnit tu = this.makeTuTarget(this.makeTu("Sentence 1\uff1f", "Sentence 2\uff01", "Sentence 3\u3001", "Sentence 4\uff0c"), LocaleId.ENGLISH, new PunctuationConversionStep.Ja2EnTranslator());
        tu = corrector.correctWhitespace((ITextUnit)tu);
        Assert.assertEquals((Object)"Sentence 1? Sentence 2! Sentence 3, Sentence 4, ", (Object)tu.getTarget(LocaleId.ENGLISH).toString());
    }

    @Test
    public void doNothingEnglishToFrench() {
        WhitespaceCorrector corrector = new WhitespaceCorrector(LocaleId.ENGLISH, LocaleId.FRENCH, new HashSet<WhitespaceCorrector.Punctuation>(Arrays.asList(WhitespaceCorrector.Punctuation.values())), (Set)WhitespaceCorrector.ALL_WHITESPACE);
        TextUnit tu = this.makeTuTarget(this.makeTu("Sentence 1?  ", "Sentence 2! ", "Sentence 3, "), LocaleId.FRENCH, new PunctuationConversionStep.En2JaTranslator());
        tu = corrector.correctWhitespace((ITextUnit)tu);
        Assert.assertEquals((Object)"Sentence 1\uff1f  Sentence 2\uff01 Sentence 3\u3001 ", (Object)tu.getTarget(LocaleId.FRENCH).toString());
    }

    private TextUnit makeTu(String ... parts) {
        TextUnit tu = new TextUnit("id1");
        for (String s : parts) {
            tu.getSource().append(new TextPart(s));
        }
        return tu;
    }

    private TextUnit makeTuTarget(TextUnit tu, LocaleId tgtLocale, PunctuationConversionStep.PunctuationTranslator trans) {
        tu.createTarget(tgtLocale, true, 0);
        for (TextPart tp : tu.getSource().getParts()) {
            String converted = trans.translate(tp.getContent().getCodedText());
            tu.getTarget(tgtLocale).append(new TextPart(converted));
        }
        return tu;
    }
}

