/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.whitespacecorrection;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.steps.whitespacecorrection.WhitespaceCorrector;

public class PunctuationConversionStep
extends BasePipelineStep {
    private PunctuationTranslator converter;
    protected LocaleId targetLocale;

    public PunctuationConversionStep(PunctuationTranslator converter) {
        this.converter = converter;
    }

    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        TextContainer target = tu.getTarget(this.targetLocale);
        for (TextPart tp : target.getParts()) {
            TextFragment tf = tp.getContent();
            tf.setCodedText(this.converter.translate(tf.getCodedText()));
        }
        return event;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    public String getName() {
        return "Convert Punctuation";
    }

    public String getDescription() {
        return "";
    }

    static class En2JaTranslator
    implements PunctuationTranslator {
        En2JaTranslator() {
        }

        @Override
        public String translate(String s) {
            for (WhitespaceCorrector.Punctuation p : WhitespaceCorrector.Punctuation.values()) {
                s = s.replace(p.getWhitespaceAcceptingForm(), p.getWhitespaceNonAcceptingForm()[0]);
            }
            return s;
        }
    }

    static class Ja2EnTranslator
    implements PunctuationTranslator {
        Ja2EnTranslator() {
        }

        @Override
        public String translate(String s) {
            for (WhitespaceCorrector.Punctuation p : WhitespaceCorrector.Punctuation.values()) {
                for (char form : p.getWhitespaceNonAcceptingForm()) {
                    s = s.replace(form, p.getWhitespaceAcceptingForm());
                }
            }
            return s;
        }
    }

    static interface PunctuationTranslator {
        public String translate(String var1);
    }
}

