/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.whitespacecorrection;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileCompare;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatch;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatchItem;
import net.sf.okapi.lib.extra.pipelinebuilder.XParameter;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipeline;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipelineStep;
import net.sf.okapi.steps.common.FilterEventsToRawDocumentStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.segmentation.Parameters;
import net.sf.okapi.steps.segmentation.SegmentationStep;
import net.sf.okapi.steps.whitespacecorrection.PunctuationConversionStep;
import net.sf.okapi.steps.whitespacecorrection.WhitespaceCorrectionStep;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class WhitespaceCorrectionStepTest {
    private static final String GOLD_DIRECTORY_NAME = "/gold";
    private FileLocation root;

    @Before
    public void initialize() {
        this.root = FileLocation.fromClass(this.getClass());
    }

    @DataProvider
    public static Object[][] roundTripDataProvider() {
        return new Object[][]{{"/text-with-kutens-and-whitespaces.html", "/text-with-periods-and-whitespaces.html", LocaleId.JAPANESE, LocaleId.ENGLISH, new HtmlFilter(), new PunctuationConversionStep.Ja2EnTranslator(), new WhitespaceCorrectionStep()}, {"/text-with-kutens-and-whitespaces.html", "/text-with-kutens.html", LocaleId.ENGLISH, LocaleId.JAPANESE, new HtmlFilter(), new PunctuationConversionStep.En2JaTranslator(), new WhitespaceCorrectionStep()}};
    }

    @Test
    @UseDataProvider(value="roundTripDataProvider")
    public void roundTrip(String inputFilename, String outputFilename, LocaleId sourceLocale, LocaleId targetLocale, IFilter filter, PunctuationConversionStep.PunctuationTranslator converter, IPipelineStep whitespaceCorrectionStep) throws Exception {
        new XPipeline("Round-trip through Events", new XBatch(new XBatchItem[]{new XBatchItem(this.root.in(inputFilename).asUri(), StandardCharsets.UTF_8.name(), sourceLocale, targetLocale)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep(filter), this.getSegmentationStep(), new PunctuationConversionStep(converter), whitespaceCorrectionStep, this.getFilterEventsToRawDocumentStep(this.root.out(outputFilename).asPath())}).execute();
        Assert.assertThat((Object)new FileCompare().filesExactlyTheSame(this.root.out(outputFilename).toString(), this.root.in(GOLD_DIRECTORY_NAME + outputFilename).toString()), (Matcher)CoreMatchers.is((Object)true));
    }

    private XPipelineStep getSegmentationStep() {
        return new XPipelineStep((IPipelineStep)new SegmentationStep(), new XParameter[]{new XParameter("sourceSrxPath", this.root.in("/segmentation-rules.srx").toString()), new XParameter("trimSrcLeadingWS", Parameters.TRIM_YES), new XParameter("trimSrcTrailingWS", Parameters.TRIM_YES), new XParameter("trimTrgLeadingWS", Parameters.TRIM_YES), new XParameter("trimTrgTrailingWS", Parameters.TRIM_YES)});
    }

    private IPipelineStep getFilterEventsToRawDocumentStep(Path outputFilePath) {
        FilterEventsToRawDocumentStep filterEventsToRawDocumentStep = new FilterEventsToRawDocumentStep();
        filterEventsToRawDocumentStep.setOutputURI(outputFilePath.toUri());
        filterEventsToRawDocumentStep.setOutputEncoding(StandardCharsets.UTF_8.name());
        return filterEventsToRawDocumentStep;
    }

    @Test
    public void testRemoveTrailingWhitespace() {
        WhitespaceCorrectionStep step = new WhitespaceCorrectionStep();
        step.setSourceLocale(LocaleId.ENGLISH);
        step.setTargetLocale(LocaleId.JAPANESE);
        TextUnit tu = new TextUnit("tu1");
        tu.setSource(new TextContainer("Hello.  "));
        tu.setTarget(LocaleId.JAPANESE, new TextContainer("Japanese\u3002  "));
        Event e = new Event(EventType.TEXT_UNIT, (IResource)tu);
        step.handleEvent(e);
        MatcherAssert.assertThat((Object)e.getTextUnit().getTarget(LocaleId.JAPANESE).toString(), (Matcher)CoreMatchers.equalTo((Object)"Japanese\u3002"));
    }
}

