/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.uriconversion;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.steps.uriconversion.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class UriConversionStep
extends BasePipelineStep {
    private static final String FORCEESCAPE = " * -,.";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Parameters params = new Parameters();
    private LocaleId trgLang;

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLanguage(LocaleId targetLanguage) {
        this.trgLang = targetLanguage;
    }

    public String getDescription() {
        return "Encodes or Decodes URI escape sequences. Expects: filter events. Sends back: filter events.";
    }

    public String getName() {
        return "URI Conversion";
    }

    public Parameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        TextContainer cont = tu.createTarget(this.trgLang, false, 7);
        try {
            for (TextPart part : cont) {
                String res = this.params.getConversionType() == 0 ? this.unescape(part.text.getCodedText()) : this.escape(part.text.getCodedText());
                part.text.setCodedText(res);
            }
        }
        catch (Exception e) {
            this.logger.error("Error when updating content: '{}'", (Object)cont.toString(), (Object)e);
        }
        return event;
    }

    private String unescape(String text) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sbTemp = new StringBuilder();
        try {
            block6: for (int i = 0; i < text.length(); ++i) {
                switch (text.charAt(i)) {
                    case '\ue101': 
                    case '\ue102': 
                    case '\ue103': {
                        sb.append(URLDecoder.decode(sbTemp.toString(), "UTF-8"));
                        sb.append(text.charAt(i));
                        sb.append(text.charAt(++i));
                        sbTemp = new StringBuilder();
                        continue block6;
                    }
                    case '+': {
                        sb.append(URLDecoder.decode(sbTemp.toString(), "UTF-8"));
                        sb.append(text.charAt(i));
                        sbTemp = new StringBuilder();
                        continue block6;
                    }
                    default: {
                        sbTemp.append(text.charAt(i));
                    }
                }
            }
            sb.append(URLDecoder.decode(sbTemp.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Error when unescaping: '{}'", (Object)text, (Object)e);
        }
        return sb.toString();
    }

    private String escape(String text) {
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 0; i < text.length(); ++i) {
                String subStr = text.substring(i, i + 1);
                if (text.charAt(i) > '\u007f' && this.params.getUpdateAll()) {
                    switch (text.charAt(i)) {
                        case '\ue101': 
                        case '\ue102': 
                        case '\ue103': {
                            sb.append(text.charAt(i));
                            sb.append(text.charAt(++i));
                            break;
                        }
                        default: {
                            sb.append(URLEncoder.encode(subStr, "UTF-8"));
                            break;
                        }
                    }
                    continue;
                }
                if (this.params.getEscapeList().contains(subStr)) {
                    if (FORCEESCAPE.contains(subStr)) {
                        byte[] bytes = subStr.getBytes();
                        sb.append("%" + Integer.toHexString(bytes[0]));
                        continue;
                    }
                    sb.append(URLEncoder.encode(subStr, "UTF-8"));
                    continue;
                }
                sb.append(text.charAt(i));
            }
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Error when escaping: '{}'", (Object)text, (Object)e);
        }
        return sb.toString();
    }
}

