/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.uriconversion.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.ISWTEmbeddableParametersEditor;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.steps.uriconversion.Parameters;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

@EditorFor(value=Parameters.class)
public class ParametersEditor
implements IParametersEditor,
ISWTEmbeddableParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Table table;
    private Button chkUpdateAll;
    private Button chkUnescape;
    private Button chkEscape;
    private Button btnFirstOption;
    private Button btnSecondOption;
    private IHelp help;
    private Composite mainComposite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.shell = null;
            this.help = (IHelp)context.getObject("help");
            this.params = (Parameters)params;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError((Shell)this.shell, (String)e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    public Composite getComposite() {
        return this.mainComposite;
    }

    public void initializeEmbeddableEditor(Composite parent, IParameters paramsObject, IContext context) {
        this.params = (Parameters)paramsObject;
        this.shell = (Shell)context.getObject("shell");
        this.createComposite(parent);
        this.setData();
    }

    public String validateAndSaveParameters() {
        if (!this.saveData()) {
            return null;
        }
        return this.params.toString();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("URI Conversion");
        if (parent != null) {
            UIUtil.inheritIcon((Shell)this.shell, (Shell)parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        this.createComposite((Composite)this.shell);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (ParametersEditor.this.help != null) {
                        ParametersEditor.this.help.showWiki("URI Conversion Step");
                    }
                    return;
                }
                if (e.widget.getData().equals("o") && !ParametersEditor.this.saveData()) {
                    return;
                }
                ParametersEditor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData((Object)new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        this.shell.setSize(this.shell.getSize().x, this.shell.getSize().y + 50);
        Dialogs.centerWindow((Shell)this.shell, (Shell)parent);
        this.setData();
    }

    private void createComposite(Composite parent) {
        int indent;
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        this.mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.chkUnescape = new Button(this.mainComposite, 16);
        this.chkUnescape.setText("Un-escape the URI escape sequences");
        this.chkUnescape.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.chkUnescape.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParametersEditor.this.chkUnescape.getSelection()) {
                    ParametersEditor.this.table.setEnabled(false);
                    ParametersEditor.this.chkUpdateAll.setEnabled(false);
                    ParametersEditor.this.btnFirstOption.setEnabled(false);
                    ParametersEditor.this.btnSecondOption.setEnabled(false);
                }
            }
        });
        this.chkEscape = new Button(this.mainComposite, 16);
        this.chkEscape.setText("Escape content to URI escape sequences");
        this.chkEscape.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.chkEscape.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParametersEditor.this.chkEscape.getSelection()) {
                    ParametersEditor.this.table.setEnabled(true);
                    ParametersEditor.this.chkUpdateAll.setEnabled(true);
                    ParametersEditor.this.btnFirstOption.setEnabled(true);
                    ParametersEditor.this.btnSecondOption.setEnabled(true);
                }
            }
        });
        Label lblList = new Label(this.mainComposite, 16384);
        lblList.setText("List of the characters to escape:");
        GridData gdTmp = new GridData(4, 4, false, false, 2, 1);
        gdTmp.horizontalIndent = indent = 16;
        lblList.setLayoutData((Object)gdTmp);
        this.table = new Table(this.mainComposite, 68384);
        gdTmp = new GridData(4, 4, true, false, 2, 1);
        gdTmp.horizontalIndent = indent;
        gdTmp.heightHint = 250;
        this.table.setLayoutData((Object)gdTmp);
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail != 32) {
                    // empty if block
                }
            }
        });
        this.chkUpdateAll = new Button(this.mainComposite, 32);
        this.chkUpdateAll.setText("Escape all extended characters");
        gdTmp = new GridData(4, 4, false, false, 2, 1);
        gdTmp.horizontalIndent = indent;
        this.chkUpdateAll.setLayoutData((Object)gdTmp);
        int buttonWidth = 170;
        this.btnFirstOption = new Button(this.mainComposite, 8);
        this.btnFirstOption.setText("All But Marks");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = indent;
        this.btnFirstOption.setLayoutData((Object)gdTmp);
        UIUtil.ensureWidth((Control)this.btnFirstOption, (int)buttonWidth);
        this.btnFirstOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectList = " `@#$^&+={}|[]\\:\";<>,?/";
                for (int i = 0; i < ParametersEditor.this.table.getItemCount(); ++i) {
                    TableItem ti = ParametersEditor.this.table.getItem(i);
                    if (selectList.contains(ti.getText(0))) {
                        ti.setChecked(true);
                        continue;
                    }
                    ti.setChecked(false);
                }
            }
        });
        this.btnSecondOption = new Button(this.mainComposite, 8);
        this.btnSecondOption.setText("All But Marks And Reserved");
        gdTmp = new GridData();
        this.btnSecondOption.setLayoutData((Object)gdTmp);
        UIUtil.ensureWidth((Control)this.btnSecondOption, (int)buttonWidth);
        this.btnSecondOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectList = " `#^{}|[]\\\"<>";
                for (int i = 0; i < ParametersEditor.this.table.getItemCount(); ++i) {
                    TableItem ti = ParametersEditor.this.table.getItem(i);
                    if (selectList.contains(ti.getText(0))) {
                        ti.setChecked(true);
                        continue;
                    }
                    ti.setChecked(false);
                }
            }
        });
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        if (this.params.getConversionType() == 0) {
            this.chkUnescape.setSelection(true);
            this.chkEscape.setSelection(false);
            this.table.setEnabled(false);
            this.chkUpdateAll.setEnabled(false);
            this.btnFirstOption.setEnabled(false);
            this.btnSecondOption.setEnabled(false);
        } else {
            this.chkUnescape.setSelection(false);
            this.chkEscape.setSelection(true);
            this.table.setEnabled(true);
            this.chkUpdateAll.setEnabled(true);
            this.btnFirstOption.setEnabled(true);
            this.btnSecondOption.setEnabled(true);
        }
        this.chkUpdateAll.setSelection(this.params.getUpdateAll());
        String allItems = " ~`!@#$^&*() +-={}|[]\\:\";'<>,.?/";
        String selList = this.params.getEscapeList();
        int len = allItems.length();
        for (int i = 0; i < len; ++i) {
            TableItem ti = new TableItem(this.table, 0);
            ti.setText("" + allItems.charAt(i));
            if (!selList.contains("" + allItems.charAt(i))) continue;
            ti.setChecked(true);
        }
    }

    private boolean saveData() {
        this.params.reset();
        if (this.chkUnescape.getSelection()) {
            this.params.setConversionType(0);
        } else {
            this.params.setConversionType(1);
        }
        this.params.setUpdateAll(this.chkUpdateAll.getSelection());
        StringBuilder selectedItems = new StringBuilder();
        selectedItems.append("%");
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            TableItem ti = this.table.getItem(i);
            if (!ti.getChecked()) continue;
            selectedItems.append(ti.getText(0));
        }
        this.params.setEscapeList(selectedItems.toString());
        this.result = true;
        return this.result;
    }
}

