/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.ttxsplitter;

import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.ttxsplitter.TTXSplitter;
import net.sf.okapi.steps.ttxsplitter.TTXSplitterParameters;

@UsingParameters(value=TTXSplitterParameters.class)
public class TTXSplitterStep
extends BasePipelineStep {
    private TTXSplitterParameters params = new TTXSplitterParameters();
    private TTXSplitter splitter;

    public String getDescription() {
        return "Splits a TTX document into several ones of roughly equal word count. Expects: raw document. Sends back: raw document.";
    }

    public String getName() {
        return "TTX Splitter";
    }

    public TTXSplitterParameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (TTXSplitterParameters)params;
    }

    protected Event handleStartBatch(Event event) {
        this.splitter = new TTXSplitter(this.params);
        return event;
    }

    protected Event handleStartBatchItem(Event event) {
        return event;
    }

    protected Event handleRawDocument(Event event) {
        RawDocument rawDoc = event.getRawDocument();
        URI uri = rawDoc.getInputURI();
        if (uri == null) {
            throw new OkapiBadStepInputException("TTX Splitter expects a URI input.");
        }
        this.splitter.split(uri);
        return event;
    }
}

