/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.ttxsplitter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.steps.ttxsplitter.TTXJoiner;
import net.sf.okapi.steps.ttxsplitter.TTXJoinerParameters;
import net.sf.okapi.steps.ttxsplitter.TTXSplitter;
import net.sf.okapi.steps.ttxsplitter.TTXSplitterParameters;
import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@RunWith(value=JUnit4.class)
public class TTXSplitterTest {
    private TTXSplitter splitter;
    private FileLocation root;

    @Before
    public void setUp() {
        this.root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void testSplitThenJoinSegmented() throws MalformedURLException, IOException, SAXException {
        this.splitThenJoin("/Test01.html");
    }

    @Test
    public void testSplitThenJoinNotSegmented() throws MalformedURLException, IOException, SAXException {
        this.splitThenJoin("/Test02_noseg.html");
    }

    private void splitThenJoin(String basename) throws MalformedURLException, IOException, SAXException {
        File oriFile = this.root.out(basename + ".ttx").asFile();
        Files.copy(this.root.in(basename + ".ttx").asPath(), oriFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        File joinedFile = this.root.out(basename + "_joined.ttx").asFile();
        joinedFile.delete();
        File part001File = this.root.out(basename + "_part001.ttx").asFile();
        part001File.delete();
        File part002File = this.root.out(basename + "_part002.ttx").asFile();
        part002File.delete();
        TTXSplitterParameters params = new TTXSplitterParameters();
        this.splitter = new TTXSplitter(params);
        this.splitter.split(oriFile.toURI());
        ArrayList<URI> inputList = new ArrayList<URI>();
        Assert.assertTrue((boolean)part001File.exists());
        inputList.add(part001File.toURI());
        Assert.assertTrue((boolean)part002File.exists());
        inputList.add(part002File.toURI());
        TTXJoinerParameters params2 = new TTXJoinerParameters();
        TTXJoiner joiner = new TTXJoiner(params2);
        joiner.process(inputList);
        InputSource original = new InputSource(new BufferedInputStream(oriFile.toURI().toURL().openStream()));
        InputSource output = new InputSource(new BufferedInputStream(joinedFile.toURI().toURL().openStream()));
        XMLAssert.assertXMLEqual((InputSource)original, (InputSource)output);
    }
}

