/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.transliteration;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.steps.transliteration.Parameters;

@UsingParameters(value=Parameters.class)
public class TransliterationStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private LocaleId targetLocale;

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    public String getName() {
        return "Text Transliteration";
    }

    public String getDescription() {
        return "Transliterates the text units content of a document. Expects: filter events. Sends back: filter events.";
    }

    public Parameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        if (this.params == null || !this.params.isValid()) {
            return event;
        }
        LocaleId toTargetLocale = this.params.getToTargetLocale();
        if (!toTargetLocale.equals((Object)this.targetLocale)) {
            return event;
        }
        LocaleId fromTargetLocale = this.params.getFromTargetLocale();
        TextContainer tc = tu.getTarget(fromTargetLocale);
        if (tc == null || !tc.hasText()) {
            return event;
        }
        for (TextPart part : tc.getParts()) {
            String oldText = part.text.getCodedText();
            String newText = this.params.getTransliterator().transliterate(oldText);
            part.text.setCodedText(newText);
        }
        tu.setTarget(toTargetLocale, tc);
        tu.removeTarget(fromTargetLocale);
        return event;
    }
}

