/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.transliteration;

import com.ibm.icu.text.Transliterator;
import com.ibm.icu.util.ULocale;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StringParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parameters
extends StringParameters {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String NO_TRANSLITERATION = "";
    private static final String ICU_TRANSLITERATOR_ID = "icuTransliteratorId";
    private static final String FROM_TARGET_LOCALE = "fromTargetLocale";
    private static final String TO_TARGET_LOCALE = "toTargetLocale";
    private Boolean lastValidation = null;
    private Transliterator trans = null;

    public String getIcuTransliteratorId() {
        return this.getString(ICU_TRANSLITERATOR_ID);
    }

    public LocaleId getFromTargetLocale() {
        return LocaleId.fromBCP47((String)this.getString(FROM_TARGET_LOCALE));
    }

    public LocaleId getToTargetLocale() {
        return LocaleId.fromBCP47((String)this.getString(TO_TARGET_LOCALE));
    }

    public boolean setIcuTransliteratorId(String icuTransliteratorId) {
        this.setString(ICU_TRANSLITERATOR_ID, icuTransliteratorId);
        if (NO_TRANSLITERATION.equals(icuTransliteratorId)) {
            this.lastValidation = false;
            return this.lastValidation;
        }
        this.lastValidation = null;
        try {
            this.trans = Transliterator.getInstance((String)icuTransliteratorId);
        }
        catch (IllegalArgumentException e) {
            this.trans = null;
            this.lastValidation = false;
            this.logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    public void setFromTargetLocale(LocaleId fromTargetLocale) {
        this.setString(FROM_TARGET_LOCALE, fromTargetLocale.toBCP47());
        this.lastValidation = null;
    }

    public void setToTargetLocale(LocaleId toTargetLocale) {
        this.setString(TO_TARGET_LOCALE, toTargetLocale.toBCP47());
        this.lastValidation = null;
    }

    Transliterator getTransliterator() {
        return this.trans;
    }

    public void reset() {
        super.reset();
        this.setIcuTransliteratorId(NO_TRANSLITERATION);
        this.setFromTargetLocale(LocaleId.EMPTY);
        this.setToTargetLocale(LocaleId.EMPTY);
    }

    public boolean isValid() {
        if (this.lastValidation == null) {
            this.lastValidation = this.isValidImpl();
        }
        return this.lastValidation;
    }

    private boolean isValidImpl() {
        if (this.lastValidation == null) {
            if (this.trans == null) {
                return false;
            }
            String transId = this.getIcuTransliteratorId();
            if (transId == null || NO_TRANSLITERATION.equals(transId)) {
                return false;
            }
            LocaleId fromTargetLocale = this.getFromTargetLocale();
            if (fromTargetLocale == null || LocaleId.EMPTY.equals((Object)fromTargetLocale)) {
                return false;
            }
            LocaleId toTargetLocale = this.getToTargetLocale();
            if (toTargetLocale == null || LocaleId.EMPTY.equals((Object)toTargetLocale)) {
                return false;
            }
            ULocale fromTargetLocaleFull = ULocale.addLikelySubtags((ULocale)fromTargetLocale.toIcuLocale());
            ULocale toTargetLocaleFull = ULocale.addLikelySubtags((ULocale)toTargetLocale.toIcuLocale());
            if (toTargetLocaleFull.equals((Object)fromTargetLocaleFull)) {
                return false;
            }
        }
        return true;
    }
}

