/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.transliteration;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.transliteration.Parameters;
import net.sf.okapi.steps.transliteration.TransliterationStep;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TransliterationStepTest {
    @Test
    public void test() {
        LocaleId locSource = LocaleId.fromString((String)"sr");
        LocaleId locTarget = LocaleId.fromString((String)"sr-Latn");
        String source = "Serbian belongs to the Slavic group of languages in the Indo-European language family.";
        String original = "\u0421\u0440\u043f\u0441\u043a\u0438 \u0458\u0435\u0437\u0438\u043a \u043f\u0440\u0438\u043f\u0430\u0434\u0430 \u0441\u043b\u043e\u0432\u0435\u043d\u0441\u043a\u043e\u0458 \u0433\u0440\u0443\u043f\u0438 \u0458\u0435\u0437\u0438\u043a\u0430 \u043f\u043e\u0440\u043e\u0434\u0438\u0446\u0435 \u0438\u043d\u0434\u043e\u0435\u0432\u0440\u043e\u043f\u0441\u043a\u0438\u0445 \u0458\u0435\u0437\u0438\u043a\u0430.";
        String expected = "Srpski jezik pripada slovenskoj grupi jezika porodice indoevropskih jezika.";
        TransliterationStep step = new TransliterationStep();
        step.setTargetLocale(locTarget);
        Parameters params = step.getParameters();
        params.setFromTargetLocale(locSource);
        params.setToTargetLocale(locTarget);
        params.setIcuTransliteratorId("Serbian-Latin/BGN");
        TextUnit res = new TextUnit("id1", source);
        res.createTarget(locSource, true, 0);
        TextContainer tcTarget = res.createTarget(locSource, true, 7);
        tcTarget.setParts(new TextPart[]{new TextPart(original)});
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)res));
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((!res.hasTarget(locSource) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)res.hasTarget(locTarget));
        Assert.assertEquals((Object)expected, (Object)res.getTarget(locTarget).toString());
    }

    @Test
    public void testComplex() {
        LocaleId locSource = LocaleId.fromString((String)"zh");
        LocaleId locTarget = LocaleId.fromString((String)"en");
        String source = "\"Laozi\", also known as \"Tao Te Ching\", is an ancient book in the pre-Qin period, and it is said to be written by Laozi, a thinker in the late Spring and Autumn Period.";
        String original = "\u300a\u8001\u5b50\u300b\uff0c\u53c8\u540d\u300a\u9053\u5fb7\u7d93\u300b\uff0c\u662f\u5148\u79e6\u6642\u671f\u7684\u53e4\u7c4d\uff0c\u76f8\u50b3\u70ba\u6625\u79cb\u672b\u671f\u601d\u60f3\u5bb6\u8001\u5b50\u6240\u8457\u3002";
        String expected = "lao zi, you mingdao de jing, shi xian qin shi qi de gu ji, xiang chuan wei chun qiu mo qi si xiang jia lao zi suo zhe.";
        TransliterationStep step = new TransliterationStep();
        step.setTargetLocale(locTarget);
        Parameters params = step.getParameters();
        params.setFromTargetLocale(locSource);
        params.setToTargetLocale(locTarget);
        params.setIcuTransliteratorId("Any-Latin;NFD;[^\\u0000-\\u007f] Remove");
        TextUnit res = new TextUnit("id1", source);
        res.createTarget(locSource, true, 0);
        TextContainer tcTarget = res.createTarget(locSource, true, 7);
        tcTarget.setParts(new TextPart[]{new TextPart(original)});
        step.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)res));
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((!res.hasTarget(locSource) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)res.hasTarget(locTarget));
        Assert.assertEquals((Object)expected, (Object)res.getTarget(locTarget).toString());
    }
}

