/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tradosutils;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.File;
import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.tradosutils.ParametersMSWordResaver;
import net.sf.okapi.steps.tradosutils.TradosUtils;

@UsingParameters(value=ParametersMSWordResaver.class)
public class MSWordResaverStep
extends BasePipelineStep {
    private ParametersMSWordResaver params = new ParametersMSWordResaver();
    ActiveXComponent word;

    protected Event handleRawDocument(Event event) {
        RawDocument rawDoc = event.getRawDocument();
        String inputPath = new File(rawDoc.getInputURI()).getPath();
        String outputPath = inputPath.replace(Util.getExtension((String)inputPath), this.getExtension(this.params.getFormat()));
        Dispatch oDocuments = this.word.getProperty("Documents").toDispatch();
        Dispatch oDocument = Dispatch.call((Dispatch)oDocuments, (String)"Open", (Object)inputPath).toDispatch();
        Dispatch.call((Dispatch)oDocument, (String)"SaveAs", (Object)outputPath, (Object)new Variant(this.params.getFormat()));
        Dispatch.call((Dispatch)oDocument, (String)"Close");
        if (this.params.getSendNew()) {
            ArrayList<Event> list = new ArrayList<Event>();
            PipelineParameters pp = new PipelineParameters();
            rawDoc = new RawDocument(new File(outputPath).toURI(), rawDoc.getEncoding(), rawDoc.getSourceLocale(), rawDoc.getTargetLocale());
            pp.setOutputURI(rawDoc.getInputURI());
            pp.setSourceLocale(rawDoc.getSourceLocale());
            pp.setTargetLocale(rawDoc.getTargetLocale());
            pp.setOutputEncoding(rawDoc.getEncoding());
            pp.setInputRawDocument(rawDoc);
            pp.setBatchInputCount(1);
            list.add(new Event(EventType.PIPELINE_PARAMETERS, (IResource)pp));
            list.add(new Event(EventType.RAW_DOCUMENT, (IResource)rawDoc));
            return new Event(EventType.MULTI_EVENT, (IResource)new MultiEvent(list));
        }
        return event;
    }

    protected Event handleStartBatch(Event event) {
        TradosUtils.verifyJavaLibPath(new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile()));
        this.word = new ActiveXComponent("Word.Application");
        this.word.setProperty("Visible", new Variant(true));
        return event;
    }

    protected Event handleEndBatch(Event event) {
        this.word.invoke("Quit");
        this.word = null;
        return event;
    }

    public String getName() {
        return "MS Word Resaver";
    }

    public String getDescription() {
        return "Open a file in MS Word and Save As selected output format. Expects: raw document. Sends back: raw document.";
    }

    public ParametersMSWordResaver getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (ParametersMSWordResaver)params;
    }

    private String getExtension(int selection) {
        switch (selection) {
            case 16: {
                return ".docx";
            }
            case 6: {
                return ".rtf";
            }
            case 0: {
                return ".doc";
            }
        }
        return "";
    }
}

