/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tradosutils;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.AbstractPart;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=ParametersTranslation.class)
public class ParametersTranslation
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String USER = "user";
    private static final String PASS = "pass";
    private static final String MINMATCH = "minMatch";
    private static final String LOGPATH = "logPath";
    private static final String EXISTINGTM = "existingTm";
    private static final String SEGUNKNOWN = "segUnknown";
    private static final String WHENCHANGED = "whenChanged";
    private static final String USEEXISTING = "useExisting";
    private static final String AUTOOPENLOG = "autoOpenLog";
    private static final String APPENDTOLOG = "appendToLog";
    private static final String OVERWRITE = "overwrite";
    private static final String SENDTM = "sendTm";

    public String getUser() {
        return this.getString(USER);
    }

    public void setUser(String user) {
        this.setString(USER, user);
    }

    public String getPass() {
        return this.getString(PASS);
    }

    public void setPass(String pass) {
        this.setString(PASS, pass);
    }

    public int getMinMatch() {
        return this.getInteger(MINMATCH);
    }

    public void setMinMatch(int minMatch) {
        this.setInteger(MINMATCH, minMatch);
    }

    public int getWhenChanged() {
        return this.getInteger(WHENCHANGED);
    }

    public void setWhenChanged(int whenChanged) {
        this.setInteger(WHENCHANGED, whenChanged);
    }

    public String getLogPath() {
        return this.getString(LOGPATH);
    }

    public void setLogPath(String logPath) {
        this.setString(LOGPATH, logPath);
    }

    public String getExistingTm() {
        return this.getString(EXISTINGTM);
    }

    public void setExistingTm(String existingTm) {
        this.setString(EXISTINGTM, existingTm);
    }

    public boolean getSegUnknown() {
        return this.getBoolean(SEGUNKNOWN);
    }

    public void setSegUnknown(boolean segUnknown) {
        this.setBoolean(SEGUNKNOWN, segUnknown);
    }

    public boolean getUseExisting() {
        return this.getBoolean(USEEXISTING);
    }

    public void setUseExisting(boolean useExisting) {
        this.setBoolean(USEEXISTING, useExisting);
    }

    public boolean getAutoOpenLog() {
        return this.getBoolean(AUTOOPENLOG);
    }

    public void setAutoOpenLog(boolean autoOpenLog) {
        this.setBoolean(AUTOOPENLOG, autoOpenLog);
    }

    public boolean getAppendToLog() {
        return this.getBoolean(APPENDTOLOG);
    }

    public void setAppendToLog(boolean appendToLog) {
        this.setBoolean(APPENDTOLOG, appendToLog);
    }

    public boolean getOverwrite() {
        return this.getBoolean(OVERWRITE);
    }

    public void setOverwrite(boolean overwrite) {
        this.setBoolean(OVERWRITE, overwrite);
    }

    public boolean getSendTm() {
        return this.getBoolean(SENDTM);
    }

    public void setSendTm(boolean sendTm) {
        this.setBoolean(SENDTM, sendTm);
    }

    public void reset() {
        super.reset();
        String tmp = System.getProperty("user.name");
        this.setUser(tmp != null ? tmp : "");
        this.setPass("");
        this.setMinMatch(100);
        this.setWhenChanged(0);
        this.setLogPath("${inputRootDir}/log.txt");
        this.setExistingTm("");
        this.setSegUnknown(false);
        this.setUseExisting(false);
        this.setAutoOpenLog(false);
        this.setAppendToLog(true);
        this.setOverwrite(false);
        this.setSendTm(false);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(USEEXISTING, "Use or create the following TM:", null);
        desc.add(OVERWRITE, "Overwrite if it exists", null);
        desc.add(SENDTM, "Send the TM to the next step", null);
        desc.add(EXISTINGTM, null, null);
        desc.add(USER, "User ID", null);
        desc.add(PASS, "TM password", "Password of the TM (leave blank if not needed)");
        desc.add(LOGPATH, "Full path of the log file", null);
        desc.add(APPENDTOLOG, "Append to the log file if one exists already", null);
        desc.add(AUTOOPENLOG, "Open the log file after completion", null);
        desc.add(MINMATCH, "Match threshold", "Accept matches with a score equal or above this threshold");
        desc.add(SEGUNKNOWN, "Segment unknown segments", null);
        desc.add(WHENCHANGED, "Update changed transalations", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Trados Translate", true, false);
        CheckboxPart cbp1 = desc.addCheckboxPart(paramDesc.get(USEEXISTING));
        CheckboxPart cbp3 = desc.addCheckboxPart(paramDesc.get(OVERWRITE));
        cbp3.setMasterPart((AbstractPart)cbp1, true);
        CheckboxPart cbp2 = desc.addCheckboxPart(paramDesc.get(SENDTM));
        cbp2.setMasterPart((AbstractPart)cbp1, true);
        PathInputPart pip = desc.addPathInputPart(paramDesc.get(EXISTINGTM), "TM File", false);
        pip.setWithLabel(false);
        pip.setMasterPart((AbstractPart)cbp1, true);
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(USER));
        tip.setVertical(false);
        tip = desc.addTextInputPart(paramDesc.get(PASS));
        tip.setAllowEmpty(true);
        tip.setPassword(true);
        tip.setVertical(false);
        tip.setMasterPart((AbstractPart)cbp1, true);
        desc.addSeparatorPart();
        pip = desc.addPathInputPart(paramDesc.get(LOGPATH), "Log Path", true);
        pip.setWithLabel(true);
        desc.addCheckboxPart(paramDesc.get(APPENDTOLOG));
        desc.addCheckboxPart(paramDesc.get(AUTOOPENLOG));
        desc.addSeparatorPart();
        SpinInputPart sip = desc.addSpinInputPart(paramDesc.get(MINMATCH));
        sip.setVertical(false);
        sip.setRange(0, 100);
        desc.addCheckboxPart(paramDesc.get(SEGUNKNOWN));
        String[] labels = new String[]{"No update", "Update TM", "Update document"};
        String[] values = new String[]{"0", "1", "2"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(WHENCHANGED), values);
        lsp.setMasterPart((AbstractPart)cbp1, true);
        lsp.setChoicesLabels(labels);
        lsp.setListType(1);
        return desc;
    }
}

