/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tradosutils;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Variant;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.UUID;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LCIDUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.RawDocument;
import org.slf4j.Logger;

class TradosUtils {
    TradosUtils() {
    }

    public static void verifyJavaLibPath(File file) {
        try {
            Object pluginRoot = ";" + URLDecoder.decode(file.getAbsolutePath(), "utf-8");
            if (((String)pluginRoot).endsWith(".jar")) {
                pluginRoot = Util.getDirectoryName((String)pluginRoot);
                Object javaLibPath = System.getProperty("java.library.path");
                if (!((String)javaLibPath).contains((CharSequence)pluginRoot)) {
                    javaLibPath = (String)javaLibPath + (String)pluginRoot;
                    System.setProperty("java.library.path", (String)javaLibPath);
                    Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
                    fieldSysPath.setAccessible(true);
                    fieldSysPath.set(null, null);
                }
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error checking/setting the java library path\n" + e.getMessage(), e);
        }
    }

    public static boolean tmExists(String tm) {
        File f = new File(tm);
        return f.exists();
    }

    public static void deleteTM(String tm) {
        File f = new File(tm);
        if (f.exists()) {
            f.delete();
        }
        if ((f = new File(tm.replace(".tmw", ".mwf"))).exists()) {
            f.delete();
        }
        if ((f = new File(tm.replace(".tmw", ".mtf"))).exists()) {
            f.delete();
        }
        if ((f = new File(tm.replace(".tmw", ".mdf"))).exists()) {
            f.delete();
        }
        if ((f = new File(tm.replace(".tmw", ".iix"))).exists()) {
            f.delete();
        }
    }

    public static void deleteLog(String log) {
        File f = new File(log);
        if (f.exists()) {
            f.delete();
        }
        String csvPath = log;
        String ext = Util.getExtension((String)log);
        if (!ext.isEmpty() && (f = new File(csvPath = log.replace(ext, ".csv"))).exists()) {
            f.delete();
        }
    }

    public static void deleteLogIfRequested(Boolean requested, String log) {
        if (requested.booleanValue()) {
            TradosUtils.deleteLog(log);
        }
    }

    public static void createTM(ActiveXComponent com, String tm, LocaleId sourceLocale, LocaleId targetLocale, Logger logger) {
        if (sourceLocale.equals((Object)new LocaleId("no", "no"))) {
            sourceLocale = new LocaleId("nb", "no");
        }
        if (targetLocale.equals((Object)new LocaleId("no", "no"))) {
            targetLocale = new LocaleId("nb", "no");
        }
        String srcLcid = LCIDUtil.getLCID_asString((LocaleId)sourceLocale);
        String trgLcid = LCIDUtil.getLCID_asString((LocaleId)targetLocale);
        if (srcLcid.equals("0")) {
            logger.warn("Could not map Okapi source locale to Trados locale. Using default EN-US.");
            srcLcid = "1033";
        }
        if (trgLcid.equals("0")) {
            logger.warn("Could not map Okapi target locale to Trados locale. Using default DE-DE.");
            trgLcid = "1031";
        }
        if (srcLcid.equals("3082")) {
            srcLcid = "1034";
        }
        if (trgLcid.equals("3082")) {
            trgLcid = "1034";
        }
        Variant[] variants = new Variant[]{new Variant((Object)tm), new Variant((Object)""), new Variant((Object)srcLcid), new Variant((Object)""), new Variant((Object)trgLcid)};
        com.invoke("CreateTMEx", variants);
    }

    public static String generateTempTmName() {
        return System.getProperty("java.io.tmpdir") + UUID.randomUUID().toString() + ".tmw";
    }

    public static Event generateAltOutput(String outFilePath, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale, String filterConfigId) {
        ArrayList<Event> list = new ArrayList<Event>();
        PipelineParameters pp = new PipelineParameters();
        RawDocument rawDoc = new RawDocument(new File(outFilePath).toURI(), defaultEncoding, sourceLocale, targetLocale, filterConfigId);
        pp.setOutputURI(rawDoc.getInputURI());
        pp.setSourceLocale(rawDoc.getSourceLocale());
        pp.setTargetLocale(rawDoc.getTargetLocale());
        pp.setOutputEncoding(rawDoc.getEncoding());
        pp.setInputRawDocument(rawDoc);
        pp.setFilterConfigurationId(rawDoc.getFilterConfigId());
        pp.setBatchInputCount(1);
        list.add(new Event(EventType.PIPELINE_PARAMETERS, (IResource)pp));
        list.add(new Event(EventType.START_BATCH_ITEM));
        list.add(new Event(EventType.RAW_DOCUMENT, (IResource)rawDoc));
        list.add(new Event(EventType.END_BATCH_ITEM));
        return new Event(EventType.MULTI_EVENT, (IResource)new MultiEvent(list));
    }
}

