/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tradosutils;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;

@EditorFor(value=ParametersMSWordResaver.class)
public class ParametersMSWordResaver
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String FORMAT = "format";
    private static final String SENDNEW = "sendNew";
    private static final String wdFormatDocumentDefault = "16";
    private static final String wdFormatRTF = "6";
    private static final String wdFormatDocument = "0";
    private static final String wdFormatFilteredHTML = "10";
    private static final String wdFormatHTML = "8";

    public int getFormat() {
        return this.getInteger(FORMAT);
    }

    public void setFormat(int format) {
        this.setInteger(FORMAT, format);
    }

    public boolean getSendNew() {
        return this.getBoolean(SENDNEW);
    }

    public void setSendNew(boolean sendNew) {
        this.setBoolean(SENDNEW, sendNew);
    }

    public void reset() {
        super.reset();
        this.setFormat(6);
        this.setSendNew(true);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(FORMAT, "Format to save as:", null);
        desc.add(SENDNEW, "Send resaved document to the next step", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("MS Word Resaver", true, false);
        String[] labels = new String[]{"Rich Text Format (RTF)", "Microsoft Office Word Format (DOC)", "Word Default Document Format (DOCX for Word 2007)", "Filtered HTML Format", "Standard HTML Format"};
        String[] values = new String[]{wdFormatRTF, wdFormatDocument, wdFormatDocumentDefault, wdFormatFilteredHTML, wdFormatHTML};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(FORMAT), values);
        lsp.setChoicesLabels(labels);
        lsp.setListType(1);
        lsp.setVertical(false);
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(SENDNEW));
        cbp.setVertical(true);
        return desc;
    }
}

