/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tradosutils;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.AbstractPart;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=ParametersAnalysis.class)
public class ParametersAnalysis
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String USEEXISTING = "useExisting";
    private static final String EXISTINGTM = "existingTm";
    private static final String USER = "user";
    private static final String PASS = "pass";
    private static final String LOGPATH = "logPath";
    private static final String AUTOOPENLOG = "autoOpenLog";
    private static final String APPENDTOLOG = "appendToLog";
    private static final String CREATEPRJTM = "createPrjTm";
    private static final String PRJTMPATH = "prjTmPath";
    private static final String EXPORTUNKNOWN = "exportUnknown";
    private static final String TMXPATH = "tmxPath";
    private static final String MAXMATCH = "maxMatch";
    private static final String SENDTMX = "sendTmx";

    public String getPrjTmPath() {
        return this.getString(PRJTMPATH);
    }

    public void setPrjTmPath(String prjTmPath) {
        this.setString(PRJTMPATH, prjTmPath);
    }

    public boolean isCreatePrjTm() {
        return this.getBoolean(CREATEPRJTM);
    }

    public void setCreatePrjTm(boolean createPrjTm) {
        this.setBoolean(CREATEPRJTM, createPrjTm);
    }

    public String getUser() {
        return this.getString(USER);
    }

    public void setUser(String user) {
        this.setString(USER, user);
    }

    public String getPass() {
        return this.getString(PASS);
    }

    public void setPass(String pass) {
        this.setString(PASS, pass);
    }

    public int getMaxMatch() {
        return this.getInteger(MAXMATCH);
    }

    public void setMaxMatch(int maxMatch) {
        this.setInteger(MAXMATCH, maxMatch);
    }

    public String getLogPath() {
        return this.getString(LOGPATH);
    }

    public void setLogPath(String logPath) {
        this.setString(LOGPATH, logPath);
    }

    public String getTmxPath() {
        return this.getString(TMXPATH);
    }

    public void setTmxPath(String tmxPath) {
        this.setString(TMXPATH, tmxPath);
    }

    public String getExistingTm() {
        return this.getString(EXISTINGTM);
    }

    public void setExistingTm(String existingTm) {
        this.setString(EXISTINGTM, existingTm);
    }

    public boolean getExportUnknown() {
        return this.getBoolean(EXPORTUNKNOWN);
    }

    public void setExportUnknown(boolean exportUnknown) {
        this.setBoolean(EXPORTUNKNOWN, exportUnknown);
    }

    public boolean getUseExisting() {
        return this.getBoolean(USEEXISTING);
    }

    public void setUseExisting(boolean useExisting) {
        this.setBoolean(USEEXISTING, useExisting);
    }

    public boolean getAutoOpenLog() {
        return this.getBoolean(AUTOOPENLOG);
    }

    public void setAutoOpenLog(boolean autoOpenLog) {
        this.setBoolean(AUTOOPENLOG, autoOpenLog);
    }

    public boolean getAppendToLog() {
        return this.getBoolean(APPENDTOLOG);
    }

    public void setAppendToLog(boolean appendToLog) {
        this.setBoolean(APPENDTOLOG, appendToLog);
    }

    public boolean getSendTmx() {
        return this.getBoolean(SENDTMX);
    }

    public void setSendTmx(boolean sendTmx) {
        this.setBoolean(SENDTMX, sendTmx);
    }

    public void reset() {
        super.reset();
        this.setUseExisting(false);
        this.setExistingTm("");
        String tmp = System.getProperty("user.name");
        this.setUser(tmp != null ? tmp : "");
        this.setPass("");
        this.setLogPath("${inputRootDir}/log.txt");
        this.setAutoOpenLog(false);
        this.setAppendToLog(true);
        this.setCreatePrjTm(false);
        this.setPrjTmPath("${inputRootDir}/project.tmw");
        this.setExportUnknown(false);
        this.setTmxPath("${inputRootDir}/unknownSegments.tmx");
        this.setMaxMatch(90);
        this.setSendTmx(true);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(USEEXISTING, "Use this existing TM:", null);
        desc.add(EXISTINGTM, null, null);
        desc.add(USER, "User ID", null);
        desc.add(PASS, "TM password", "Password of the TM (leave blank if not needed)");
        desc.add(LOGPATH, "Full path of the log file", null);
        desc.add(APPENDTOLOG, "Append to the log file if one exists already", null);
        desc.add(AUTOOPENLOG, "Open the log file after completion", null);
        desc.add(CREATEPRJTM, "Create project TM:", null);
        desc.add(PRJTMPATH, "Full path of the new Trados project TM to create", "Full path of the new Trados project TM to create");
        desc.add(EXPORTUNKNOWN, "Export unknown segments:", null);
        desc.add(TMXPATH, "Full path of the new TMX document to create", "Full path of the new TMX document to create");
        desc.add(MAXMATCH, "Export threshold", "Export segments with no match above this threshold");
        desc.add(SENDTMX, "Send the TMX document to the next step", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Trados Analysis", true, false);
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(USEEXISTING));
        PathInputPart pip = desc.addPathInputPart(paramDesc.get(EXISTINGTM), "TM File", false);
        pip.setWithLabel(false);
        pip.setMasterPart((AbstractPart)cbp, true);
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(USER));
        tip.setVertical(false);
        tip = desc.addTextInputPart(paramDesc.get(PASS));
        tip.setAllowEmpty(true);
        tip.setPassword(true);
        tip.setVertical(false);
        tip.setMasterPart((AbstractPart)cbp, true);
        desc.addSeparatorPart();
        pip = desc.addPathInputPart(paramDesc.get(LOGPATH), "Log Path", true);
        pip.setWithLabel(true);
        cbp = desc.addCheckboxPart(paramDesc.get(APPENDTOLOG));
        cbp = desc.addCheckboxPart(paramDesc.get(AUTOOPENLOG));
        desc.addSeparatorPart();
        cbp = desc.addCheckboxPart(paramDesc.get(CREATEPRJTM));
        pip = desc.addPathInputPart(paramDesc.get(PRJTMPATH), "TM Path", true);
        pip.setMasterPart((AbstractPart)cbp, true);
        pip.setWithLabel(false);
        desc.addSeparatorPart();
        cbp = desc.addCheckboxPart(paramDesc.get(EXPORTUNKNOWN));
        pip = desc.addPathInputPart(paramDesc.get(TMXPATH), "TMX Path", true);
        pip.setMasterPart((AbstractPart)cbp, true);
        pip.setWithLabel(false);
        SpinInputPart sip = desc.addSpinInputPart(paramDesc.get(MAXMATCH));
        sip.setVertical(false);
        sip.setRange(0, 100);
        sip.setMasterPart((AbstractPart)cbp, true);
        CheckboxPart cbp2 = desc.addCheckboxPart(paramDesc.get(SENDTMX));
        cbp2.setMasterPart((AbstractPart)cbp, true);
        return desc;
    }
}

