/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tradosutils;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Variant;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.tradosutils.ParametersImport;
import net.sf.okapi.steps.tradosutils.TradosUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=ParametersImport.class)
public class TradosImportStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ParametersImport params;
    private ArrayList<String> inputFiles = new ArrayList();
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private String rootDir;
    private String inputRootDir;
    private String tmPath;
    private boolean sendTm;
    private int batchInputCount;
    private int count;

    public TradosImportStep() {
        this.params = new ParametersImport();
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourcetLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.BATCH_INPUT_COUNT)
    public void setBatchInputCount(int batchInputCount) {
        this.batchInputCount = batchInputCount;
    }

    protected Event handleRawDocument(Event event) {
        RawDocument rawDoc = event.getRawDocument();
        this.inputFiles.add(new File(rawDoc.getInputURI()).getPath());
        ++this.count;
        if (this.count >= this.batchInputCount) {
            Event newEvent = this.execute();
            if (this.sendTm) {
                return newEvent;
            }
            return event;
        }
        if (this.sendTm) {
            return Event.createNoopEvent();
        }
        return event;
    }

    protected Event handleStartBatch(Event event) {
        this.inputFiles.clear();
        this.count = 0;
        TradosUtils.verifyJavaLibPath(new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile()));
        this.sendTm = this.params.getSendTm();
        return event;
    }

    protected Event handleStartBatchItem(Event event) {
        if (this.sendTm) {
            return Event.createNoopEvent();
        }
        return event;
    }

    protected Event handleEndBatchItem(Event event) {
        return Event.createNoopEvent();
    }

    private Event execute() {
        this.tmPath = Util.fillRootDirectoryVariable((String)this.params.getExistingTm(), (String)this.rootDir);
        this.tmPath = Util.fillInputRootDirectoryVariable((String)this.tmPath, (String)this.inputRootDir);
        this.tmPath = LocaleId.replaceVariables((String)this.tmPath, (LocaleId)this.sourceLocale, (LocaleId)this.targetLocale);
        if (TradosUtils.tmExists(this.tmPath)) {
            if (this.params.getOverwrite()) {
                TradosUtils.deleteTM(this.tmPath);
                this.importIntoTM(this.tmPath, this.inputFiles, true);
            } else {
                this.importIntoTM(this.tmPath, this.inputFiles, false);
            }
        } else {
            this.importIntoTM(this.tmPath, this.inputFiles, true);
        }
        if (this.sendTm) {
            return TradosUtils.generateAltOutput(this.tmPath, "UTF-8", this.sourceLocale, this.targetLocale, "okf_tmx");
        }
        return null;
    }

    public String getName() {
        return "Trados Import";
    }

    public String getDescription() {
        return "Import a set of input files into a Trados TM. Expects: raw document. Sends back: raw document.";
    }

    public ParametersImport getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (ParametersImport)params;
    }

    private void importIntoTM(String tm, List<String> files, boolean createTm) {
        ActiveXComponent xl = new ActiveXComponent("TW4Win.Application");
        try {
            if (createTm) {
                Util.createDirectories((String)tm);
                TradosUtils.createTM(xl, tm, this.sourceLocale, this.targetLocale, this.logger);
            }
            ActiveXComponent o = xl.getPropertyAsComponent("TranslationMemory");
            if (!this.params.getPass().isEmpty()) {
                o.invoke("Open", new Variant((Object)tm), new Variant((Object)this.params.getUser()), new Variant((Object)this.params.getPass()));
            } else {
                o.invoke("Open", new Variant((Object)tm), new Variant((Object)this.params.getUser()));
            }
            Variant[] importOptions = new Variant[6];
            importOptions[1] = new Variant(this.params.getMode());
            importOptions[2] = new Variant(this.params.getFormat());
            importOptions[3] = new Variant(this.params.getReorganize());
            importOptions[4] = new Variant(this.params.getIgnoreNewFields());
            importOptions[5] = new Variant(this.params.getCheckLang());
            for (String file : files) {
                importOptions[0] = new Variant((Object)file);
                o.invoke("Import", importOptions);
            }
            xl.invoke("quit", new Variant[0]);
        }
        catch (Exception e) {
            throw new OkapiIOException("Trados Import failed.", (Throwable)e);
        }
    }
}

