/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tradosutils;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Variant;
import java.io.File;
import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.tradosutils.ParametersExport;
import net.sf.okapi.steps.tradosutils.TradosUtils;

@UsingParameters(value=ParametersExport.class)
public class TradosExportStep
extends BasePipelineStep {
    private ParametersExport params = new ParametersExport();
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private String rootDir;
    private String inputRootDir;
    private ActiveXComponent trados;
    private ActiveXComponent tm;

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourcetLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    protected Event handleRawDocument(Event event) {
        RawDocument rawDoc = event.getRawDocument();
        String inputPath = new File(rawDoc.getInputURI()).getPath();
        try {
            if (!this.params.getPass().isEmpty()) {
                this.tm.invoke("Open", new Variant((Object)inputPath), new Variant((Object)this.params.getUser()), new Variant((Object)this.params.getPass()));
            } else {
                this.tm.invoke("Open", new Variant((Object)inputPath), new Variant((Object)this.params.getUser()));
            }
            String outputPath = inputPath.replace(Util.getExtension((String)inputPath), this.getExtension(this.params.getFormat()));
            Variant[] importOptions = new Variant[3];
            importOptions[0] = new Variant((Object)outputPath);
            importOptions[1] = new Variant(this.params.getFormat());
            String path = Util.fillRootDirectoryVariable((String)this.params.getConstraintsFile(), (String)this.rootDir);
            path = Util.fillInputRootDirectoryVariable((String)path, (String)this.inputRootDir);
            path = LocaleId.replaceVariables((String)path, (LocaleId)this.sourceLocale, (LocaleId)this.targetLocale);
            importOptions[2] = new Variant((Object)path);
            this.tm.invoke("Export", importOptions);
            this.tm.invoke("Close");
            if (this.params.getSendExportedFile()) {
                ArrayList<Event> list = new ArrayList<Event>();
                PipelineParameters pp = new PipelineParameters();
                rawDoc = new RawDocument(new File(outputPath).toURI(), "UTF-8", this.sourceLocale, this.targetLocale);
                rawDoc.setFilterConfigId(this.params.getFilterConfigurationForExportFormat(this.params.getFormat()));
                pp.setOutputURI(rawDoc.getInputURI());
                pp.setSourceLocale(rawDoc.getSourceLocale());
                pp.setTargetLocale(rawDoc.getTargetLocale());
                pp.setOutputEncoding(rawDoc.getEncoding());
                pp.setInputRawDocument(rawDoc);
                pp.setFilterConfigurationId(rawDoc.getFilterConfigId());
                pp.setBatchInputCount(1);
                list.add(new Event(EventType.PIPELINE_PARAMETERS, (IResource)pp));
                list.add(new Event(EventType.RAW_DOCUMENT, (IResource)rawDoc));
                return new Event(EventType.MULTI_EVENT, (IResource)new MultiEvent(list));
            }
            return event;
        }
        catch (Exception e) {
            throw new OkapiIOException("Trados Export failed.", (Throwable)e);
        }
    }

    protected Event handleStartBatch(Event event) {
        TradosUtils.verifyJavaLibPath(new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile()));
        this.trados = new ActiveXComponent("TW4Win.Application");
        this.tm = this.trados.getPropertyAsComponent("TranslationMemory");
        return event;
    }

    protected Event handleEndBatch(Event event) {
        this.trados.invoke("quit", new Variant[0]);
        this.trados = null;
        this.tm = null;
        return event;
    }

    public String getName() {
        return "Trados Export";
    }

    public String getDescription() {
        return "Export a Trados TM to a selected format. Expects: raw document. Sends back: raw document.";
    }

    public ParametersExport getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (ParametersExport)params;
    }

    private String getExtension(int selection) {
        switch (selection) {
            case 10: {
                return ".txt";
            }
            case 6: 
            case 8: 
            case 9: {
                return ".tmx";
            }
            case 2: {
                return ".rtf";
            }
            case 1: {
                return ".sgm";
            }
        }
        return "";
    }
}

