/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tradosutils;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Variant;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.tradosutils.ParametersTranslation;
import net.sf.okapi.steps.tradosutils.TradosUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=ParametersTranslation.class)
public class TradosTranslationStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ParametersTranslation params;
    private ArrayList<String> inputFiles = new ArrayList();
    private String logToOpen;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private String rootDir;
    private String inputRootDir;
    private String tmPath;
    private boolean sendTm;
    private int batchInputCount;
    private int count;

    public TradosTranslationStep() {
        this.params = new ParametersTranslation();
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourcetLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.BATCH_INPUT_COUNT)
    public void setBatchInputCount(int batchInputCount) {
        this.batchInputCount = batchInputCount;
    }

    protected Event handleRawDocument(Event event) {
        RawDocument rawDoc = event.getRawDocument();
        this.inputFiles.add(new File(rawDoc.getInputURI()).getPath());
        ++this.count;
        if (this.count >= this.batchInputCount) {
            Event newEvent = this.execute();
            if (this.sendTm) {
                return newEvent;
            }
            return event;
        }
        if (this.sendTm) {
            return Event.createNoopEvent();
        }
        return event;
    }

    protected Event handleStartBatch(Event event) {
        this.inputFiles.clear();
        this.logToOpen = null;
        this.count = 0;
        TradosUtils.verifyJavaLibPath(new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile()));
        this.sendTm = this.params.getSendTm() && this.params.getUseExisting();
        return event;
    }

    protected Event handleStartBatchItem(Event event) {
        if (this.sendTm) {
            return Event.createNoopEvent();
        }
        return event;
    }

    protected Event handleEndBatchItem(Event event) {
        return Event.createNoopEvent();
    }

    protected Event execute() {
        File jobFile;
        StringBuffer job = new StringBuffer();
        job.append("[Translate]\n");
        this.logToOpen = Util.fillRootDirectoryVariable((String)this.params.getLogPath(), (String)this.rootDir);
        this.logToOpen = Util.fillInputRootDirectoryVariable((String)this.logToOpen, (String)this.inputRootDir);
        this.logToOpen = LocaleId.replaceVariables((String)this.logToOpen, (LocaleId)this.sourceLocale, (LocaleId)this.targetLocale);
        TradosUtils.deleteLogIfRequested(!this.params.getAppendToLog(), this.logToOpen);
        Util.createDirectories((String)this.logToOpen);
        job.append("LogFile=" + this.logToOpen + "\n");
        job.append("MinMatch=" + this.params.getMinMatch() + "\n");
        job.append("SegmentUnknown=" + (this.params.getSegUnknown() ? 1 : 2) + "\n");
        job.append("whenChanged=" + this.params.getWhenChanged() + "\n");
        job.append("Files=" + this.inputFiles.size() + "\n");
        int i = 1;
        for (String file : this.inputFiles) {
            job.append("File" + i + "=" + file + "\n");
            ++i;
        }
        try {
            jobFile = File.createTempFile("~okapi-53_tradosjobfile_", ".tmp");
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jobFile), StandardCharsets.UTF_16LE));){
                out.write("\ufeff");
                out.write(job.toString());
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException("Cannot create temporary output.", e);
        }
        if (!this.params.getUseExisting()) {
            String tempName = TradosUtils.generateTempTmName();
            this.translateWithTM(tempName, jobFile.getPath(), true);
            TradosUtils.deleteTM(tempName);
        } else {
            this.tmPath = Util.fillRootDirectoryVariable((String)this.params.getExistingTm(), (String)this.rootDir);
            this.tmPath = Util.fillInputRootDirectoryVariable((String)this.tmPath, (String)this.inputRootDir);
            this.tmPath = LocaleId.replaceVariables((String)this.tmPath, (LocaleId)this.sourceLocale, (LocaleId)this.targetLocale);
            if (TradosUtils.tmExists(this.tmPath)) {
                if (this.params.getOverwrite()) {
                    TradosUtils.deleteTM(this.tmPath);
                    this.translateWithTM(this.tmPath, jobFile.getPath(), true);
                } else {
                    this.translateWithTM(this.tmPath, jobFile.getPath(), false);
                }
            } else {
                this.translateWithTM(this.tmPath, jobFile.getPath(), true);
            }
        }
        if (this.sendTm) {
            return TradosUtils.generateAltOutput(this.tmPath, "UTF-8", this.sourceLocale, this.targetLocale, "okf_tmx");
        }
        return null;
    }

    public String getName() {
        return "Trados Translation";
    }

    public String getDescription() {
        return "Pre-Translate a set of input files with a Trados TM. Expects: raw document. Sends back: raw document.";
    }

    public ParametersTranslation getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (ParametersTranslation)params;
    }

    private void translateWithTM(String tm, String job, boolean createTm) {
        ActiveXComponent xl = new ActiveXComponent("TW4Win.Application");
        try {
            if (createTm) {
                Util.createDirectories((String)tm);
                TradosUtils.createTM(xl, tm, this.sourceLocale, this.targetLocale, this.logger);
            }
            ActiveXComponent o = xl.getPropertyAsComponent("TranslationMemory");
            if (!this.params.getPass().isEmpty()) {
                o.invoke("Open", new Variant((Object)tm), new Variant((Object)this.params.getUser()), new Variant((Object)this.params.getPass()));
            } else {
                o.invoke("Open", new Variant((Object)tm), new Variant((Object)this.params.getUser()));
            }
            o.invoke("TranslateFiles", new Variant((Object)job));
            xl.invoke("quit", new Variant[0]);
            if (this.params.getAutoOpenLog() && this.logToOpen != null) {
                Util.openURL((String)new File(this.logToOpen).getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new OkapiIOException("Trados Translation failed.", (Throwable)e);
        }
    }
}

