/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tradosutils;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.File;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.tradosutils.ParametersSearchAndReplaceWord;

@UsingParameters(value=ParametersSearchAndReplaceWord.class)
public class SearchAndReplaceWordStep
extends BasePipelineStep {
    private ParametersSearchAndReplaceWord params = new ParametersSearchAndReplaceWord();
    private String[] search;
    private String[] replace;
    ActiveXComponent oWord;

    protected Event handleRawDocument(Event event) {
        RawDocument rawDoc = event.getRawDocument();
        String inputPath = new File(rawDoc.getInputURI()).getPath();
        Dispatch oDocuments = this.oWord.getProperty("Documents").toDispatch();
        Dispatch oDocument = Dispatch.call((Dispatch)oDocuments, (String)"Open", (Object)inputPath).toDispatch();
        Dispatch oSelection = this.oWord.getProperty("Selection").toDispatch();
        Dispatch oFind = Dispatch.call((Dispatch)oSelection, (String)"Find").toDispatch();
        Dispatch oReplacement = Dispatch.get((Dispatch)oFind, (String)"Replacement").toDispatch();
        Variant f = new Variant(false);
        Variant t = new Variant(true);
        for (int i = 0; i < this.params.rules.size(); ++i) {
            if (!this.params.rules.get(i)[0].equals("true")) continue;
            Boolean hasFormatting = false;
            Dispatch.call((Dispatch)oFind, (String)"ClearFormatting");
            String findStyle = this.params.rules.get(i)[3];
            if (findStyle != null && findStyle.length() > 0) {
                Dispatch.put((Dispatch)oFind, (String)"Style", (Object)findStyle);
                hasFormatting = true;
            }
            Dispatch.call((Dispatch)oReplacement, (String)"ClearFormatting");
            String replacementStyle = this.params.rules.get(i)[4];
            if (replacementStyle != null && replacementStyle.length() > 0) {
                Dispatch.put((Dispatch)oReplacement, (String)"Style", (Object)replacementStyle);
                hasFormatting = true;
            }
            Dispatch.callN((Dispatch)oFind, (String)"Execute", (Object[])new Variant[]{new Variant((Object)this.params.rules.get(i)[1]), new Variant(this.params.getMatchCase()), new Variant(this.params.getWholeWord()), new Variant(this.params.getRegEx()), f, f, t, new Variant(2), new Variant((Object)hasFormatting), new Variant((Object)this.replace[i]), new Variant(2)});
        }
        Dispatch.call((Dispatch)oDocument, (String)"Save");
        Dispatch.call((Dispatch)oDocument, (String)"Close");
        return event;
    }

    protected Event handleStartBatch(Event event) {
        int i;
        this.oWord = new ActiveXComponent("Word.Application");
        this.oWord.setProperty("Visible", new Variant(true));
        this.search = new String[this.params.rules.size()];
        for (i = 0; i < this.params.rules.size(); ++i) {
            this.search[i] = this.params.rules.get(i)[1];
        }
        this.replace = new String[this.params.rules.size()];
        for (i = 0; i < this.params.rules.size(); ++i) {
            this.replace[i] = this.params.rules.get(i)[2];
        }
        return event;
    }

    protected Event handleEndBatch(Event event) {
        this.oWord.invoke("Quit");
        this.oWord = null;
        return event;
    }

    public String getName() {
        return "MS Word Search and Replace";
    }

    public String getDescription() {
        return "Search and Replace in word document. Expects: raw document. Sends back: raw document.";
    }

    public IParameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (ParametersSearchAndReplaceWord)params;
    }
}

