/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tradosutils;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=ParametersImport.class)
public class ParametersImport
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String USER = "user";
    private static final String PASS = "pass";
    private static final String EXISTINGTM = "existingTm";
    private static final String MODE = "mode";
    private static final String FORMAT = "format";
    private static final String REORGANIZE = "reorganize";
    private static final String IGNORENEWFIELDS = "ignoreNewFields";
    private static final String CHECKLANG = "checkLang";
    private static final String OVERWRITE = "overwrite";
    private static final String SENDTM = "sendTm";

    public String getUser() {
        return this.getString(USER);
    }

    public void setUser(String user) {
        this.setString(USER, user);
    }

    public String getPass() {
        return this.getString(PASS);
    }

    public void setPass(String pass) {
        this.setString(PASS, pass);
    }

    public int getMode() {
        return this.getInteger(MODE);
    }

    public void setMode(int mode) {
        this.setInteger(MODE, mode);
    }

    public int getFormat() {
        return this.getInteger(FORMAT);
    }

    public void setFormat(int format) {
        this.setInteger(FORMAT, format);
    }

    public String getExistingTm() {
        return this.getString(EXISTINGTM);
    }

    public void setExistingTm(String existingTm) {
        this.setString(EXISTINGTM, existingTm);
    }

    public boolean getCheckLang() {
        return this.getBoolean(CHECKLANG);
    }

    public void setCheckLang(boolean checkLang) {
        this.setBoolean(CHECKLANG, checkLang);
    }

    public boolean getReorganize() {
        return this.getBoolean(REORGANIZE);
    }

    public void setReorganize(boolean reorganize) {
        this.setBoolean(REORGANIZE, reorganize);
    }

    public boolean getIgnoreNewFields() {
        return this.getBoolean(IGNORENEWFIELDS);
    }

    public void setIgnoreNewFields(boolean ignoreNewFields) {
        this.setBoolean(IGNORENEWFIELDS, ignoreNewFields);
    }

    public boolean getOverwrite() {
        return this.getBoolean(OVERWRITE);
    }

    public void setOverwrite(boolean overwrite) {
        this.setBoolean(OVERWRITE, overwrite);
    }

    public boolean getSendTm() {
        return this.getBoolean(SENDTM);
    }

    public void setSendTm(boolean sendTm) {
        this.setBoolean(SENDTM, sendTm);
    }

    public void reset() {
        super.reset();
        String tmp = System.getProperty("user.name");
        this.setUser(tmp != null ? tmp : "");
        this.setPass("");
        this.setMode(2);
        this.setFormat(9);
        this.setExistingTm("");
        this.setReorganize(false);
        this.setIgnoreNewFields(false);
        this.setCheckLang(false);
        this.setOverwrite(false);
        this.setSendTm(false);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(EXISTINGTM, "Use or create the TM you want to import into", null);
        desc.add(OVERWRITE, "Overwrite if it exists", null);
        desc.add(SENDTM, "Send the TM to the next step", null);
        desc.add(USER, "User ID", null);
        desc.add(PASS, "TM password", "Password of the TM (leave blank if not needed)");
        desc.add(MODE, "Existing translation units:", null);
        desc.add(FORMAT, "Import format:", null);
        desc.add(REORGANIZE, "Large import file (with reorganization) ", null);
        desc.add(IGNORENEWFIELDS, "Ignore new fields", null);
        desc.add(CHECKLANG, "Check matching sub-languages", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Trados Import", true, false);
        desc.addPathInputPart(paramDesc.get(EXISTINGTM), "TM File", false);
        desc.addCheckboxPart(paramDesc.get(OVERWRITE));
        desc.addCheckboxPart(paramDesc.get(SENDTM));
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(USER));
        tip.setVertical(false);
        tip = desc.addTextInputPart(paramDesc.get(PASS));
        tip.setAllowEmpty(true);
        tip.setPassword(true);
        tip.setVertical(false);
        desc.addSeparatorPart();
        String[] labels = new String[]{"Leave unchanged", "Keep most recent", "Keep oldest", "Merge", "Overwrite"};
        String[] values = new String[]{"0", "3", "4", "1", "2"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(MODE), values);
        lsp.setChoicesLabels(labels);
        lsp.setListType(1);
        lsp.setVertical(false);
        String[] labels2 = new String[]{"Translator's Workbench (*.txt)", "TMX 1.1 (*.tmx)", "TMX 1.4 (*.tmx)", "TMX 1.4b (*.tmx)", "Systran (*.rtf)", "Logos (*.sgm)"};
        String[] values2 = new String[]{"10", "6", "8", "9", "2", "1"};
        lsp = desc.addListSelectionPart(paramDesc.get(FORMAT), values2);
        lsp.setChoicesLabels(labels2);
        lsp.setListType(1);
        lsp.setVertical(false);
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(REORGANIZE));
        cbp = desc.addCheckboxPart(paramDesc.get(IGNORENEWFIELDS));
        cbp = desc.addCheckboxPart(paramDesc.get(CHECKLANG));
        cbp.setVertical(true);
        return desc;
    }
}

