/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tradosutils;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=ParametersExport.class)
public class ParametersExport
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String USER = "user";
    private static final String PASS = "pass";
    private static final String CONSTRAINTSFILE = "constraintsFile";
    private static final String FORMAT = "format";
    private static final String SENDEXPORTEDFILE = "sendExportedFile";

    public String getUser() {
        return this.getString(USER);
    }

    public void setUser(String user) {
        this.setString(USER, user);
    }

    public String getPass() {
        return this.getString(PASS);
    }

    public void setPass(String pass) {
        this.setString(PASS, pass);
    }

    public int getFormat() {
        return this.getInteger(FORMAT);
    }

    public void setFormat(int format) {
        this.setInteger(FORMAT, format);
    }

    public String getConstraintsFile() {
        return this.getString(CONSTRAINTSFILE);
    }

    public void setConstraintsFile(String constraintsFile) {
        this.setString(CONSTRAINTSFILE, constraintsFile);
    }

    public boolean getSendExportedFile() {
        return this.getBoolean(SENDEXPORTEDFILE);
    }

    public void setSendExportedFile(boolean sendExportedFile) {
        this.setBoolean(SENDEXPORTEDFILE, sendExportedFile);
    }

    public void reset() {
        super.reset();
        String tmp = System.getProperty("user.name");
        this.setUser(tmp != null ? tmp : "");
        this.setPass("");
        this.setFormat(9);
        this.setConstraintsFile("");
        this.setSendExportedFile(false);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(CONSTRAINTSFILE, "Select filter constraints file", null);
        desc.add(USER, "User ID", null);
        desc.add(PASS, "TM password", "Password of the TM (leave blank if not needed)");
        desc.add(FORMAT, "Export format:", null);
        desc.add(SENDEXPORTEDFILE, "Send exported document to the next step", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Trados Export", true, false);
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(USER));
        tip.setVertical(false);
        tip = desc.addTextInputPart(paramDesc.get(PASS));
        tip.setAllowEmpty(true);
        tip.setPassword(true);
        tip.setVertical(false);
        desc.addSeparatorPart();
        String[] labels = new String[]{"Translator's Workbench (*.txt)", "Tmx 1.1 (*.tmx)", "Tmx 1.4 (*.tmx)", "Tmx 1.4b (*.tmx)", "Systran (*.rtf)", "Logos (*.sgm)"};
        String[] values = new String[]{"10", "6", "8", "9", "2", "1"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(FORMAT), values);
        lsp.setChoicesLabels(labels);
        lsp.setListType(1);
        lsp.setVertical(false);
        PathInputPart pip = desc.addPathInputPart(paramDesc.get(CONSTRAINTSFILE), "Select filter constraints file", false);
        pip.setBrowseFilters("Constraint Settings File (*.wcs)\tAll Files (*.*)", "*.wcs\t*.*");
        pip.setAllowEmpty(true);
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(SENDEXPORTEDFILE));
        cbp.setVertical(true);
        return desc;
    }

    public String getFilterConfigurationForExportFormat(int formatCode) {
        switch (formatCode) {
            case 6: 
            case 8: 
            case 9: {
                return "okf_tmx";
            }
        }
        return null;
    }
}

