/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tradosutils;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Variant;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.tradosutils.ParametersAnalysis;
import net.sf.okapi.steps.tradosutils.TradosUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=ParametersAnalysis.class)
public class TradosAnalysisStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ParametersAnalysis params;
    private ArrayList<String> inputFiles = new ArrayList();
    private String logToOpen;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private String rootDir;
    private String inputRootDir;
    private boolean sendTmx;
    private int batchInputCount;
    private int count;

    public TradosAnalysisStep() {
        this.params = new ParametersAnalysis();
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourcetLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.BATCH_INPUT_COUNT)
    public void setBatchInputCount(int batchInputCount) {
        this.batchInputCount = batchInputCount;
    }

    protected Event handleRawDocument(Event event) {
        RawDocument rawDoc = event.getRawDocument();
        this.inputFiles.add(new File(rawDoc.getInputURI()).getPath());
        ++this.count;
        if (this.count >= this.batchInputCount) {
            Event newEvent = this.execute();
            if (this.sendTmx) {
                return newEvent;
            }
            return event;
        }
        if (this.sendTmx) {
            return Event.NOOP_EVENT;
        }
        return event;
    }

    protected Event handleStartBatch(Event event) {
        this.inputFiles.clear();
        this.logToOpen = null;
        this.count = 0;
        TradosUtils.verifyJavaLibPath(new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile()));
        this.sendTmx = this.params.getSendTmx() && this.params.getExportUnknown();
        return event;
    }

    protected Event handleStartBatchItem(Event event) {
        if (this.sendTmx) {
            return Event.NOOP_EVENT;
        }
        return event;
    }

    protected Event handleEndBatchItem(Event event) {
        return Event.NOOP_EVENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event execute() {
        File jobFile;
        StringBuffer job = new StringBuffer();
        job.append("[Analyse]\n");
        this.logToOpen = Util.fillRootDirectoryVariable((String)this.params.getLogPath(), (String)this.rootDir);
        this.logToOpen = Util.fillInputRootDirectoryVariable((String)this.logToOpen, (String)this.inputRootDir);
        this.logToOpen = LocaleId.replaceVariables((String)this.logToOpen, (LocaleId)this.sourceLocale, (LocaleId)this.targetLocale);
        TradosUtils.deleteLogIfRequested(!this.params.getAppendToLog(), this.logToOpen);
        Util.createDirectories((String)this.logToOpen);
        int taskCount = 1;
        if (this.params.getExportUnknown()) {
            ++taskCount;
        }
        if (this.params.isCreatePrjTm()) {
            ++taskCount;
        }
        job.append("LogFile=" + this.logToOpen + "\n");
        job.append("Tasks=" + taskCount + "\n");
        job.append("[Task1]\n");
        job.append("Task=Analyse\n");
        job.append("Files=" + this.inputFiles.size() + "\n");
        int i = 1;
        for (String file : this.inputFiles) {
            job.append("File" + i + "=" + file + "\n");
            ++i;
        }
        String tmxOutput = Util.fillRootDirectoryVariable((String)this.params.getTmxPath(), (String)this.rootDir);
        tmxOutput = Util.fillInputRootDirectoryVariable((String)tmxOutput, (String)this.inputRootDir);
        tmxOutput = LocaleId.replaceVariables((String)tmxOutput, (LocaleId)this.sourceLocale, (LocaleId)this.targetLocale);
        Util.createDirectories((String)tmxOutput);
        if (this.params.getExportUnknown()) {
            job.append("[Task2]\n");
            job.append("Task=ExportUnknown\n");
            job.append("MaxMatch=" + this.params.getMaxMatch() + "\n");
            job.append("File=" + tmxOutput + "\n");
            job.append("FileType=5\n");
        }
        if (this.params.isCreatePrjTm()) {
            String tmOutput = Util.fillRootDirectoryVariable((String)this.params.getPrjTmPath(), (String)this.rootDir);
            tmOutput = Util.fillInputRootDirectoryVariable((String)tmOutput, (String)this.inputRootDir);
            tmOutput = LocaleId.replaceVariables((String)tmOutput, (LocaleId)this.sourceLocale, (LocaleId)this.targetLocale);
            Util.createDirectories((String)tmOutput);
            if (this.params.getExportUnknown()) {
                job.append("[Task3]\n");
            } else {
                job.append("[Task2]\n");
            }
            job.append("Task=CreateProjectTM\n");
            job.append("File=" + tmOutput + "\n");
        }
        try {
            jobFile = File.createTempFile("~okapi-51_tradosjobfile_", ".tmp");
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jobFile), "UTF-16LE"));){
                out.write("\ufeff");
                out.write(job.toString());
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException("Cannot create temporary output.", e);
        }
        if (!this.params.getUseExisting()) {
            String tempName = TradosUtils.generateTempTmName();
            this.analyzeWithTM(tempName, jobFile.getPath(), true);
            TradosUtils.deleteTM(tempName);
        } else {
            String tmPath = Util.fillRootDirectoryVariable((String)this.params.getExistingTm(), (String)this.rootDir);
            tmPath = Util.fillInputRootDirectoryVariable((String)tmPath, (String)this.inputRootDir);
            tmPath = LocaleId.replaceVariables((String)tmPath, (LocaleId)this.sourceLocale, (LocaleId)this.targetLocale);
            this.analyzeWithTM(tmPath, jobFile.getPath(), false);
        }
        if (this.sendTmx) {
            return TradosUtils.generateAltOutput(tmxOutput, "UTF-8", this.sourceLocale, this.targetLocale, "okf_tmx");
        }
        return null;
    }

    public String getName() {
        return "Trados Analysis";
    }

    public String getDescription() {
        return "Analyses a set of input files with a Trados TM. Expects: raw document. Sends back: raw document.";
    }

    public IParameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (ParametersAnalysis)params;
    }

    private void analyzeWithTM(String tm, String job, boolean createTm) {
        ActiveXComponent xl = new ActiveXComponent("TW4Win.Application");
        try {
            if (createTm) {
                TradosUtils.createTM(xl, tm, this.sourceLocale, this.targetLocale, this.logger);
            }
            ActiveXComponent o = xl.getPropertyAsComponent("TranslationMemory");
            if (!this.params.getPass().isEmpty()) {
                o.invoke("Open", new Variant((Object)tm), new Variant((Object)this.params.getUser()), new Variant((Object)this.params.getPass()));
            } else {
                o.invoke("Open", new Variant((Object)tm), new Variant((Object)this.params.getUser()));
            }
            o.invoke("AnalyseFiles", new Variant((Object)job));
            xl.invoke("quit", new Variant[0]);
            if (this.params.getAutoOpenLog() && this.logToOpen != null) {
                Util.openURL((String)new File(this.logToOpen).getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new OkapiIOException("Trados Analysis failed.", (Throwable)e);
        }
    }
}

