/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import net.sf.okapi.common.AbstractGroupParameters;
import net.sf.okapi.common.ParametersString;

public class TokenConfigs
extends AbstractGroupParameters
implements List<TokenConfig> {
    private final List<TokenConfig> tokenConfigs = new ArrayList<TokenConfig>();
    private final TreeMap<Integer, TokenConfig> idMap = new TreeMap();

    public void reset() {
        if (this.tokenConfigs != null) {
            this.tokenConfigs.clear();
        }
    }

    public void load(ParametersString buffer) {
        this.loadGroup(buffer, "Token", this.tokenConfigs, TokenConfig.class);
        this.idMap.clear();
        for (TokenConfig c : this.tokenConfigs) {
            this.idMap.put(c.getId(), c);
        }
    }

    public void save(ParametersString buffer) {
        this.saveGroup(buffer, "Token", this.tokenConfigs);
    }

    public TokenConfig getRule(int tokenId) {
        return this.idMap.get(tokenId);
    }

    @Override
    public boolean add(TokenConfig o) {
        return this.tokenConfigs.add(o);
    }

    @Override
    public void add(int index, TokenConfig element) {
        this.tokenConfigs.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends TokenConfig> c) {
        return this.tokenConfigs.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends TokenConfig> c) {
        return this.tokenConfigs.addAll(index, c);
    }

    @Override
    public void clear() {
        this.tokenConfigs.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.tokenConfigs.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.tokenConfigs.containsAll(c);
    }

    @Override
    public TokenConfig get(int index) {
        return this.tokenConfigs.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.tokenConfigs.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.tokenConfigs.isEmpty();
    }

    @Override
    public Iterator<TokenConfig> iterator() {
        return this.tokenConfigs.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.tokenConfigs.lastIndexOf(o);
    }

    @Override
    public ListIterator<TokenConfig> listIterator() {
        return this.tokenConfigs.listIterator();
    }

    @Override
    public ListIterator<TokenConfig> listIterator(int index) {
        return this.tokenConfigs.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.tokenConfigs.remove(o);
    }

    @Override
    public TokenConfig remove(int index) {
        return this.tokenConfigs.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.tokenConfigs.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.tokenConfigs.retainAll(c);
    }

    @Override
    public TokenConfig set(int index, TokenConfig element) {
        return this.tokenConfigs.set(index, element);
    }

    @Override
    public int size() {
        return this.tokenConfigs.size();
    }

    @Override
    public List<TokenConfig> subList(int fromIndex, int toIndex) {
        return this.tokenConfigs.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.tokenConfigs.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.tokenConfigs.toArray(a);
    }

    public static class TokenConfig
    extends AbstractGroupParameters {
        private String name;
        private String description;
        private int id;
        private String sample;

        public void reset() {
            this.name = "";
            this.description = "";
            this.id = 0;
            this.sample = "";
        }

        protected void load(ParametersString buffer) {
            this.name = buffer.getString("name", "");
            this.description = buffer.getString("description", "");
            this.id = buffer.getInteger("id", 0);
            this.sample = buffer.getString("sample", "");
        }

        protected void save(ParametersString buffer) {
            buffer.setString("name", this.name);
            buffer.setString("description", this.description);
            buffer.setInteger("id", this.id);
            buffer.setString("sample", this.sample);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getSample() {
            return this.sample;
        }

        public void setSample(String sample) {
            this.sample = sample;
        }
    }
}

