/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckListPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.steps.tokenization.ITokenizer;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String TOKENIZESOURCE = "tokenizeSource";
    private static final String TOKENIZETARGETS = "tokenizeTargets";
    private static final String FILTEREDLOCALES = "filteredLocales";
    private boolean tokenizeSource;
    private boolean tokenizeTargets;
    private List<String> includedTokenNames;
    private String filterLocales;
    private boolean WORD;
    private boolean HYPHENATED_WORD;
    private boolean NUMBER;
    private boolean WHITESPACE;
    private boolean PUNCTUATION;
    private boolean DATE;
    private boolean TIME;
    private boolean CURRENCY;
    private boolean ABBREVIATION;
    private boolean MARKUP;
    private boolean EMAIL;
    private boolean INTERNET;
    private boolean EMOTICON;
    private boolean EMOJI;
    private boolean OTHER_SYMBOL;
    private boolean KANA;
    private boolean IDEOGRAM;

    public void reset() {
        super.reset();
        this.includedTokenNames = new ArrayList<String>();
        this.includedTokenNames.add(ITokenizer.TokenType.WORD.name());
        this.includedTokenNames.add(ITokenizer.TokenType.HYPHENATED_WORD.name());
        this.includedTokenNames.add(ITokenizer.TokenType.NUMBER.name());
        this.setTokenizeSource(true);
        this.setTokenizeTargets(false);
        this.setFilteredLocales(null);
        this.resetTokens();
    }

    private void resetTokens() {
        this.setWORD(false);
        this.setHYPHENATED_WORD(false);
        this.setNUMBER(false);
        this.setPUNCTUATION(false);
        this.setWHITESPACE(false);
        this.setABBREVIATION(false);
        this.setINTERNET(false);
        this.setEMAIL(false);
        this.setEMOTICON(false);
        this.setEMOJI(false);
        this.setDATE(false);
        this.setCURRENCY(false);
        this.setTIME(false);
        this.setMARKUP(false);
        this.setOTHER_SYMBOL(false);
        this.setKANA(false);
        this.setIDEOGRAM(false);
    }

    public boolean isWORD() {
        this.WORD = this.buffer.getBoolean(ITokenizer.TokenType.WORD.name());
        return this.WORD;
    }

    public void setWORD(boolean bWORD) {
        this.WORD = bWORD;
        this.buffer.setBoolean(ITokenizer.TokenType.WORD.name(), bWORD);
    }

    public boolean isHYPHENATED_WORD() {
        this.HYPHENATED_WORD = this.buffer.getBoolean(ITokenizer.TokenType.HYPHENATED_WORD.name());
        return this.HYPHENATED_WORD;
    }

    public void setHYPHENATED_WORD(boolean HYPHENATED_WORD) {
        this.HYPHENATED_WORD = HYPHENATED_WORD;
        this.buffer.setBoolean(ITokenizer.TokenType.HYPHENATED_WORD.name(), HYPHENATED_WORD);
    }

    public boolean isNUMBER() {
        this.NUMBER = this.buffer.getBoolean(ITokenizer.TokenType.NUMBER.name());
        return this.NUMBER;
    }

    public void setNUMBER(boolean NUMBER) {
        this.NUMBER = NUMBER;
        this.buffer.setBoolean(ITokenizer.TokenType.NUMBER.name(), NUMBER);
    }

    public boolean isWHITESPACE() {
        this.WHITESPACE = this.buffer.getBoolean(ITokenizer.TokenType.WHITESPACE.name());
        return this.WHITESPACE;
    }

    public void setWHITESPACE(boolean WHITESPACE) {
        this.WHITESPACE = WHITESPACE;
        this.buffer.setBoolean(ITokenizer.TokenType.WHITESPACE.name(), WHITESPACE);
    }

    public boolean isPUNCTUATION() {
        this.PUNCTUATION = this.buffer.getBoolean(ITokenizer.TokenType.PUNCTUATION.name());
        return this.PUNCTUATION;
    }

    public void setPUNCTUATION(boolean PUNCTUATION) {
        this.PUNCTUATION = PUNCTUATION;
        this.buffer.setBoolean(ITokenizer.TokenType.PUNCTUATION.name(), PUNCTUATION);
    }

    public boolean isDATE() {
        this.DATE = this.buffer.getBoolean(ITokenizer.TokenType.DATE.name());
        return this.DATE;
    }

    public void setDATE(boolean DATE) {
        this.DATE = DATE;
        this.buffer.setBoolean(ITokenizer.TokenType.DATE.name(), DATE);
    }

    public boolean isTIME() {
        this.TIME = this.buffer.getBoolean(ITokenizer.TokenType.TIME.name());
        return this.TIME;
    }

    public void setTIME(boolean TIME) {
        this.TIME = TIME;
        this.buffer.setBoolean(ITokenizer.TokenType.TIME.name(), TIME);
    }

    public boolean isCURRENCY() {
        this.CURRENCY = this.buffer.getBoolean(ITokenizer.TokenType.CURRENCY.name());
        return this.CURRENCY;
    }

    public void setCURRENCY(boolean CURRENCY) {
        this.CURRENCY = CURRENCY;
        this.buffer.setBoolean(ITokenizer.TokenType.CURRENCY.name(), CURRENCY);
    }

    public boolean isABBREVIATION() {
        this.ABBREVIATION = this.buffer.getBoolean(ITokenizer.TokenType.ABBREVIATION.name());
        return this.ABBREVIATION;
    }

    public void setABBREVIATION(boolean ABBREVIATION) {
        this.ABBREVIATION = ABBREVIATION;
        this.buffer.setBoolean(ITokenizer.TokenType.ABBREVIATION.name(), ABBREVIATION);
    }

    public boolean isMARKUP() {
        this.MARKUP = this.buffer.getBoolean(ITokenizer.TokenType.MARKUP.name());
        return this.MARKUP;
    }

    public void setMARKUP(boolean MARKUP) {
        this.MARKUP = MARKUP;
        this.buffer.setBoolean(ITokenizer.TokenType.MARKUP.name(), MARKUP);
    }

    public boolean isEMAIL() {
        this.EMAIL = this.buffer.getBoolean(ITokenizer.TokenType.EMAIL.name());
        return this.EMAIL;
    }

    public void setEMAIL(boolean EMAIL) {
        this.EMAIL = EMAIL;
        this.buffer.setBoolean(ITokenizer.TokenType.EMAIL.name(), EMAIL);
    }

    public boolean isINTERNET() {
        this.INTERNET = this.buffer.getBoolean(ITokenizer.TokenType.INTERNET.name());
        return this.INTERNET;
    }

    public void setINTERNET(boolean INTERNET) {
        this.INTERNET = INTERNET;
        this.buffer.setBoolean(ITokenizer.TokenType.INTERNET.name(), INTERNET);
    }

    public boolean isEMOTICON() {
        this.EMOTICON = this.buffer.getBoolean(ITokenizer.TokenType.EMOTICON.name());
        return this.EMOTICON;
    }

    public void setEMOTICON(boolean EMOTICON) {
        this.EMOTICON = EMOTICON;
        this.buffer.setBoolean(ITokenizer.TokenType.EMOTICON.name(), EMOTICON);
    }

    public boolean isEMOJI() {
        this.EMOJI = this.buffer.getBoolean(ITokenizer.TokenType.EMOJI.name());
        return this.EMOJI;
    }

    public void setEMOJI(boolean EMOJI) {
        this.EMOJI = EMOJI;
        this.buffer.setBoolean(ITokenizer.TokenType.EMOJI.name(), EMOJI);
    }

    public boolean isOTHER_SYMBOL() {
        this.OTHER_SYMBOL = this.buffer.getBoolean(ITokenizer.TokenType.EMOJI.name());
        return this.OTHER_SYMBOL;
    }

    public void setOTHER_SYMBOL(boolean OTHER_SYMBOL) {
        this.OTHER_SYMBOL = OTHER_SYMBOL;
        this.buffer.setBoolean(ITokenizer.TokenType.OTHER_SYMBOL.name(), OTHER_SYMBOL);
    }

    public boolean isKANA() {
        this.KANA = this.buffer.getBoolean(ITokenizer.TokenType.KANA.name());
        return this.KANA;
    }

    public void setKANA(boolean KANA) {
        this.KANA = KANA;
        this.buffer.setBoolean(ITokenizer.TokenType.KANA.name(), KANA);
    }

    public boolean isIDEOGRAM() {
        this.IDEOGRAM = this.buffer.getBoolean(ITokenizer.TokenType.IDEOGRAM.name());
        return this.IDEOGRAM;
    }

    public void setIDEOGRAM(boolean IDEOGRAM) {
        this.IDEOGRAM = IDEOGRAM;
        this.buffer.setBoolean(ITokenizer.TokenType.IDEOGRAM.name(), IDEOGRAM);
    }

    public boolean isTokenizeSource() {
        return this.getBoolean(TOKENIZESOURCE);
    }

    public void setTokenizeSource(boolean tokenizeSource) {
        this.setBoolean(TOKENIZESOURCE, tokenizeSource);
    }

    public String getFilteredLocales() {
        return this.getString(FILTEREDLOCALES);
    }

    public void setFilteredLocales(String filteredLocales) {
        this.setString(FILTEREDLOCALES, filteredLocales);
    }

    public boolean isTokenizeTargets() {
        return this.getBoolean(TOKENIZETARGETS);
    }

    public void setTokenizeTargets(boolean tokenizeTargets) {
        this.setBoolean(TOKENIZETARGETS, tokenizeTargets);
    }

    public List<String> getIncludedTokenNames() {
        this.includedTokenNames.clear();
        if (this.WORD) {
            this.includedTokenNames.add(ITokenizer.TokenType.WORD.name());
        }
        if (this.HYPHENATED_WORD) {
            this.includedTokenNames.add(ITokenizer.TokenType.HYPHENATED_WORD.name());
        }
        if (this.NUMBER) {
            this.includedTokenNames.add(ITokenizer.TokenType.NUMBER.name());
        }
        if (this.WHITESPACE) {
            this.includedTokenNames.add(ITokenizer.TokenType.WHITESPACE.name());
        }
        if (this.PUNCTUATION) {
            this.includedTokenNames.add(ITokenizer.TokenType.PUNCTUATION.name());
        }
        if (this.DATE) {
            this.includedTokenNames.add(ITokenizer.TokenType.DATE.name());
        }
        if (this.TIME) {
            this.includedTokenNames.add(ITokenizer.TokenType.TIME.name());
        }
        if (this.CURRENCY) {
            this.includedTokenNames.add(ITokenizer.TokenType.CURRENCY.name());
        }
        if (this.ABBREVIATION) {
            this.includedTokenNames.add(ITokenizer.TokenType.ABBREVIATION.name());
        }
        if (this.MARKUP) {
            this.includedTokenNames.add(ITokenizer.TokenType.MARKUP.name());
        }
        if (this.EMAIL) {
            this.includedTokenNames.add(ITokenizer.TokenType.EMAIL.name());
        }
        if (this.INTERNET) {
            this.includedTokenNames.add(ITokenizer.TokenType.INTERNET.name());
        }
        if (this.EMOTICON) {
            this.includedTokenNames.add(ITokenizer.TokenType.EMOTICON.name());
        }
        if (this.EMOJI) {
            this.includedTokenNames.add(ITokenizer.TokenType.EMOJI.name());
        }
        if (this.OTHER_SYMBOL) {
            this.includedTokenNames.add(ITokenizer.TokenType.OTHER_SYMBOL.name());
        }
        if (this.IDEOGRAM) {
            this.includedTokenNames.add(ITokenizer.TokenType.IDEOGRAM.name());
        }
        if (this.KANA) {
            this.includedTokenNames.add(ITokenizer.TokenType.KANA.name());
        }
        return this.includedTokenNames;
    }

    public void setIncludedTokenNames(String ... includedTokenNames) {
        this.includedTokenNames = ListUtil.arrayAsList((Object[])includedTokenNames);
        this.resetTokens();
        block19: for (String n : includedTokenNames) {
            ITokenizer.TokenType t = ITokenizer.TokenType.valueOf(n);
            switch (t) {
                case WORD: {
                    this.setWORD(true);
                    continue block19;
                }
                case HYPHENATED_WORD: {
                    this.setHYPHENATED_WORD(true);
                    continue block19;
                }
                case NUMBER: {
                    this.setNUMBER(true);
                    continue block19;
                }
                case WHITESPACE: {
                    this.setWHITESPACE(true);
                    continue block19;
                }
                case PUNCTUATION: {
                    this.setPUNCTUATION(true);
                    continue block19;
                }
                case DATE: {
                    this.setDATE(true);
                    continue block19;
                }
                case TIME: {
                    this.setTIME(true);
                    continue block19;
                }
                case CURRENCY: {
                    this.setCURRENCY(true);
                    continue block19;
                }
                case ABBREVIATION: {
                    this.setABBREVIATION(true);
                    continue block19;
                }
                case MARKUP: {
                    this.setMARKUP(true);
                    continue block19;
                }
                case EMAIL: {
                    this.setEMAIL(true);
                    continue block19;
                }
                case INTERNET: {
                    this.setINTERNET(true);
                    continue block19;
                }
                case EMOTICON: {
                    this.setEMOTICON(true);
                    continue block19;
                }
                case EMOJI: {
                    this.setEMOJI(true);
                    continue block19;
                }
                case OTHER_SYMBOL: {
                    this.setOTHER_SYMBOL(true);
                    continue block19;
                }
                case IDEOGRAM: {
                    this.setIDEOGRAM(true);
                    continue block19;
                }
                case KANA: {
                    this.setKANA(true);
                    continue block19;
                }
            }
        }
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(TOKENIZESOURCE, "Tokenize Source", "Create selected tokens for source locale");
        desc.add(TOKENIZETARGETS, "Tokenize Targets", "Create selected tokens for target locales");
        for (ITokenizer.TokenType t : ITokenizer.TokenType.values()) {
            String name = t.name();
            String description = t.getDescription();
            desc.add(name, name, description);
        }
        desc.add(FILTEREDLOCALES, "Locales to Filter", "Locale names or patterns used that are excluded from tokenization");
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Tokenizer", true, false);
        desc.addCheckboxPart(paramsDesc.get(TOKENIZESOURCE));
        desc.addCheckboxPart(paramsDesc.get(TOKENIZETARGETS));
        CheckListPart clp = desc.addCheckListPart("TokenType to Extract", 100);
        for (ITokenizer.TokenType t : ITokenizer.TokenType.values()) {
            String name = t.name();
            clp.addEntry(paramsDesc.get(name));
        }
        desc.addTextInputPart(paramsDesc.get(FILTEREDLOCALES));
        return desc;
    }
}

