/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleFilter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.steps.tokenization.Parameters;
import net.sf.okapi.steps.tokenization.TokenizationStep;
import net.sf.okapi.steps.tokenization.common.TokensAnnotation;
import net.sf.okapi.steps.tokenization.tokens.Tokens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tokenizer {
    protected static TokenizationStep ts = new TokenizationStep();

    protected static synchronized Tokens tokenizeString(String text, LocaleId language, String ... tokenNames) {
        Tokens res = new Tokens();
        if (ts == null) {
            return res;
        }
        Parameters params = (Parameters)ts.getParameters();
        params.reset();
        params.tokenizeSource = true;
        params.tokenizeTargets = false;
        params.setLocaleFilter(LocaleFilter.anyOf((LocaleId[])new LocaleId[]{language}));
        params.setTokenNames(tokenNames);
        ts.handleEvent(new Event(EventType.START_BATCH));
        StartDocument startDoc = new StartDocument("tokenization");
        startDoc.setLocale(language);
        startDoc.setMultilingual(false);
        Event event = new Event(EventType.START_DOCUMENT, (IResource)startDoc);
        ts.handleEvent(event);
        ITextUnit tu = TextUnitUtil.buildTU((String)text);
        event = new Event(EventType.TEXT_UNIT, (IResource)tu);
        ts.handleEvent(event);
        TokensAnnotation ta = (TokensAnnotation)TextUnitUtil.getSourceAnnotation((ITextUnit)tu, TokensAnnotation.class);
        if (ta != null) {
            res.addAll(ta.getTokens());
        }
        ts.handleEvent(new Event(EventType.END_BATCH));
        return res;
    }

    private static Tokens doTokenize(Object text, LocaleId language, String ... tokenNames) {
        if (text == null) {
            return null;
        }
        if (Util.isNullOrEmpty((LocaleId)language)) {
            Logger localLogger = LoggerFactory.getLogger(Tokenizer.class);
            localLogger.warn("Language is not set, cannot tokenize.");
            return null;
        }
        if (text instanceof ITextUnit) {
            ITextUnit tu = (ITextUnit)text;
            if (tu.hasTarget(language)) {
                return Tokenizer.doTokenize(tu.getTarget(language), language, tokenNames);
            }
            return Tokenizer.doTokenize(tu.getSource(), language, tokenNames);
        }
        if (text instanceof TextContainer) {
            TextContainer tc = (TextContainer)text;
            if (tc.contentIsOneSegment()) {
                return Tokenizer.doTokenize(tc.getFirstContent(), language, tokenNames);
            }
            return Tokenizer.doTokenize(tc.getUnSegmentedContentCopy(), language, tokenNames);
        }
        if (text instanceof TextFragment) {
            TextFragment tf = (TextFragment)text;
            return Tokenizer.doTokenize(TextUnitUtil.getText((TextFragment)tf), language, tokenNames);
        }
        if (text instanceof String) {
            return Tokenizer.tokenizeString((String)text, language, tokenNames);
        }
        return null;
    }

    public static Tokens tokenize(ITextUnit textUnit, LocaleId language, String ... tokenNames) {
        return Tokenizer.doTokenize(textUnit, language, tokenNames);
    }

    public static Tokens tokenize(TextContainer textContainer, LocaleId language, String ... tokenNames) {
        return Tokenizer.doTokenize(textContainer, language, tokenNames);
    }

    public static Tokens tokenize(TextFragment textFragment, LocaleId language, String ... tokenNames) {
        return Tokenizer.doTokenize(textFragment, language, tokenNames);
    }

    public static Tokens tokenize(String string, LocaleId language, String ... tokenNames) {
        return Tokenizer.doTokenize(string, language, tokenNames);
    }
}

