/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.engine;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.Util;
import net.sf.okapi.steps.tokenization.common.AbstractLexer;
import net.sf.okapi.steps.tokenization.common.Lexem;
import net.sf.okapi.steps.tokenization.common.Lexems;
import net.sf.okapi.steps.tokenization.common.Token;
import net.sf.okapi.steps.tokenization.tokens.Tokens;

public class Reconciler
extends AbstractLexer {
    private LinkedHashMap<String, List<Integer>> sameRangeMap;
    private LinkedHashMap<Integer, List<Integer>> sameScoreMap;
    private LinkedHashMap<Integer, List<Integer>> reverseSameScoreMap;
    private Tokens deletedTokens;

    @Override
    protected boolean lexer_hasNext() {
        return false;
    }

    @Override
    protected void lexer_init() {
        this.sameRangeMap = new LinkedHashMap();
        this.sameScoreMap = new LinkedHashMap();
        this.reverseSameScoreMap = new LinkedHashMap();
        this.deletedTokens = new Tokens();
    }

    @Override
    protected Lexem lexer_next() {
        return null;
    }

    @Override
    protected void lexer_open(String text, LocaleId language, Tokens tokens) {
    }

    private boolean contains(Range range, Range range2) {
        return range.start < range2.start && range.end >= range2.end || range.start <= range2.start && range.end > range2.end;
    }

    private String formRangeId(Range range) {
        if (range == null) {
            return null;
        }
        return String.format("%d %d", range.start, range.end);
    }

    private void setSameRangeMap(Tokens tokens) {
        if (tokens == null) {
            return;
        }
        if (this.sameRangeMap == null) {
            return;
        }
        this.sameRangeMap.clear();
        for (int index = 0; index < tokens.size(); ++index) {
            Token token = (Token)tokens.get(index);
            if (token == null || token.isDeleted()) continue;
            String rangeId = this.formRangeId(token.getRange());
            List<Integer> list = this.sameRangeMap.get(rangeId);
            if (list == null) {
                list = new ArrayList<Integer>();
                this.sameRangeMap.put(rangeId, list);
            }
            list.add(index);
        }
    }

    private boolean getSameTokenIds(Token token1, Token token2) {
        return token1.getTokenId() == token2.getTokenId();
    }

    private boolean getSameRules(Token token1, Token token2) {
        return token1.getLexerId() == token2.getLexerId() && token1.getLexemId() == token2.getLexemId();
    }

    private void setSameScoreMap(Tokens tokens) {
        if (tokens == null) {
            return;
        }
        if (Util.isEmpty(this.sameRangeMap)) {
            return;
        }
        if (this.sameScoreMap == null) {
            return;
        }
        this.sameScoreMap.clear();
        this.reverseSameScoreMap.clear();
        for (List<Integer> list : this.sameRangeMap.values()) {
            for (int i = 0; i < list.size(); ++i) {
                int index1 = list.get(i);
                Token token1 = (Token)tokens.get(index1);
                if (token1 == null || token1.isDeleted()) continue;
                for (int j = 0; j < list.size(); ++j) {
                    List<Integer> groupIndices2;
                    int index2;
                    Token token2;
                    if (i >= j || (token2 = (Token)tokens.get(index2 = list.get(j).intValue())) == null || token2.isDeleted() || token2 == token1) continue;
                    boolean sameTokenIds = this.getSameTokenIds(token1, token2);
                    boolean sameRules = this.getSameRules(token1, token2);
                    if (!(sameTokenIds && sameRules || !sameTokenIds && sameRules) && (!sameTokenIds || sameRules)) continue;
                    List<Integer> groupIndices = this.sameScoreMap.get(index1);
                    if (groupIndices == null) {
                        groupIndices = new ArrayList<Integer>();
                        this.sameScoreMap.put(index1, groupIndices);
                    }
                    if (!groupIndices.contains(index2)) {
                        groupIndices.add(index2);
                    }
                    if ((groupIndices2 = this.reverseSameScoreMap.get(index2)) == null) {
                        groupIndices2 = new ArrayList<Integer>();
                        this.reverseSameScoreMap.put(index2, groupIndices2);
                    }
                    if (groupIndices2.contains(index1)) continue;
                    groupIndices2.add(index1);
                }
            }
        }
        for (Integer key : this.sameScoreMap.keySet()) {
            List<Integer> groupIndices = this.sameScoreMap.get(key);
            if (groupIndices == null) continue;
            for (int i = groupIndices.size() - 1; i >= 0; --i) {
                List<Integer> reverseIndices;
                int index = groupIndices.get(i);
                List<Integer> groupIndices2 = this.sameScoreMap.get(index);
                if (groupIndices2 != null) {
                    for (int index2 : groupIndices2) {
                        if (index2 == index || groupIndices.contains(index2)) continue;
                        groupIndices.add(index2);
                    }
                }
                if ((reverseIndices = this.reverseSameScoreMap.get(index)) == null) continue;
                for (int index2 : reverseIndices) {
                    if (index2 == key || groupIndices.contains(index2)) continue;
                    groupIndices.add(index2);
                }
            }
        }
    }

    private boolean firstIsNewer(Token token1, Token token2) {
        if (token1 == null) {
            return false;
        }
        if (token2 == null) {
            return true;
        }
        return token1.getLexerId() > token2.getLexerId() || token1.getLexerId() == token2.getLexerId() && token1.getLexemId() > token2.getLexemId();
    }

    private void biggerEatsSmaller(Token bigger, Token smaller) {
        if (bigger == null) {
            return;
        }
        if (smaller == null) {
            return;
        }
        if (bigger.isDeleted()) {
            return;
        }
        if (!bigger.isImmutable() && smaller.isImmutable()) {
            return;
        }
        smaller.delete();
    }

    @Override
    public Lexems process(String text, LocaleId language, Tokens tokens) {
        this.setSameRangeMap(tokens);
        this.setSameScoreMap(tokens);
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = (Token)tokens.get(i);
            if (token.isDeleted()) continue;
            for (int j = 0; j < tokens.size(); ++j) {
                Token token2;
                if (i >= j || (token2 = (Token)tokens.get(j)).isDeleted() || token2 == token) continue;
                Range r1 = token.getRange();
                Range r2 = token2.getRange();
                if (r1.start == r2.start && r1.end == r2.end) {
                    if (token.getTokenId() != token2.getTokenId()) continue;
                    if (this.firstIsNewer(token, token2)) {
                        token2.delete();
                        continue;
                    }
                    token.delete();
                    continue;
                }
                if (this.contains(r1, r2)) {
                    this.biggerEatsSmaller(token, token2);
                    continue;
                }
                if (!this.contains(r2, r1)) continue;
                this.biggerEatsSmaller(token2, token);
            }
        }
        this.deletedTokens.clear();
        for (Token token : tokens) {
            if (token == null || !token.isDeleted()) continue;
            this.deletedTokens.add(token);
        }
        for (Integer n : this.sameScoreMap.keySet()) {
            Token token;
            if (!Util.checkIndex((int)n, (List)tokens) || (token = (Token)tokens.get(n)) == null || token.isDeleted()) continue;
            List<Integer> list = this.sameScoreMap.get(n);
            for (Integer index2 : list) {
                token = (Token)tokens.get(index2);
                if (token == null) continue;
                token.delete();
            }
        }
        for (List list : this.sameRangeMap.values()) {
            Token token;
            int size = 0;
            for (Integer index : list) {
                if (!Util.checkIndex((int)index, (List)tokens) || (token = (Token)tokens.get(index)) == null || token.isDeleted()) continue;
                ++size;
            }
            for (Integer index : list) {
                token = (Token)tokens.get(index);
                if (token == null || token.isDeleted()) continue;
                token.setScore(100 / size);
                token.undelete();
            }
        }
        for (Integer n : this.sameScoreMap.keySet()) {
            Token token;
            if (!Util.checkIndex((int)n, (List)tokens) || (token = (Token)tokens.get(n)) == null || this.deletedTokens.contains(token)) continue;
            int score = token.getScore();
            List<Integer> groupIndices = this.sameScoreMap.get(n);
            if (groupIndices == null) continue;
            for (Integer groupIndex : groupIndices) {
                Token groupToken = (Token)tokens.get(groupIndex);
                if (this.deletedTokens.contains(groupToken)) continue;
                groupToken.setScore(score);
                groupToken.undelete();
            }
        }
        return null;
    }
}

