/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.lib.extra.AbstractParameters;
import net.sf.okapi.steps.tokenization.common.LexerRule;

public class LexerRules
extends AbstractParameters
implements List<LexerRule> {
    private List<LexerRule> rules = new ArrayList<LexerRule>();
    private TreeMap<Integer, LexerRule> idMap = new TreeMap();

    protected Class<? extends LexerRule> getRuleClass() {
        return LexerRule.class;
    }

    protected void parameters_init() {
    }

    public void parameters_reset() {
        if (this.rules != null) {
            this.rules.clear();
        }
    }

    public void parameters_load(ParametersString buffer) {
        this.loadGroup(buffer, "Rule", this.rules, this.getRuleClass());
        ArrayList<Integer> usedIDs = new ArrayList<Integer>();
        for (LexerRule rule : this.rules) {
            int id = rule.getLexemId();
            if (id == 0 && usedIDs.contains(id)) {
                while (usedIDs.contains(id)) {
                    ++id;
                }
                rule.setLexemId(id);
            }
            usedIDs.add(id);
        }
        this.idMap.clear();
        for (LexerRule rule : this.rules) {
            this.idMap.put(rule.getLexemId(), rule);
        }
    }

    public void parameters_save(ParametersString buffer) {
        this.saveGroup(buffer, "Rule", this.rules);
    }

    public LexerRule getRule(int lexemId) {
        return this.idMap.get(lexemId);
    }

    @Override
    public boolean add(LexerRule o) {
        return this.rules.add(o);
    }

    @Override
    public void add(int index, LexerRule element) {
        this.rules.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends LexerRule> c) {
        return this.rules.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends LexerRule> c) {
        return this.rules.addAll(index, c);
    }

    @Override
    public void clear() {
        this.rules.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.rules.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.rules.containsAll(c);
    }

    @Override
    public LexerRule get(int index) {
        return this.rules.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.rules.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    @Override
    public Iterator<LexerRule> iterator() {
        return this.rules.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.rules.lastIndexOf(o);
    }

    @Override
    public ListIterator<LexerRule> listIterator() {
        return this.rules.listIterator();
    }

    @Override
    public ListIterator<LexerRule> listIterator(int index) {
        return this.rules.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.rules.remove(o);
    }

    @Override
    public LexerRule remove(int index) {
        return this.rules.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.rules.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.rules.retainAll(c);
    }

    @Override
    public LexerRule set(int index, LexerRule element) {
        return this.rules.set(index, element);
    }

    @Override
    public int size() {
        return this.rules.size();
    }

    @Override
    public List<LexerRule> subList(int fromIndex, int toIndex) {
        return this.rules.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.rules.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.rules.toArray(a);
    }

    public boolean hasOutTokens() {
        for (LexerRule rule : this) {
            if (rule == null || rule.getOutTokenIDs() == null || rule.getOutTokenIDs().size() <= 0) continue;
            return true;
        }
        return false;
    }
}

