/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.ui;

import java.util.List;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.LocaleFilter;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.abstracteditor.IDialogPage;
import net.sf.okapi.common.ui.abstracteditor.SWTUtil;
import net.sf.okapi.steps.tokenization.Parameters;
import net.sf.okapi.steps.tokenization.ui.locale.LanguageSelector;
import net.sf.okapi.steps.tokenization.ui.locale.LanguageSelectorPePage;
import net.sf.okapi.steps.tokenization.ui.tokens.TokenSelector;
import net.sf.okapi.steps.tokenization.ui.tokens.TokenSelectorPePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class OptionsTab
extends Composite
implements IDialogPage {
    private Group grpTokenizeInThe;
    private Button source;
    private Button targets;
    private Button langC;
    private Button tokensC;
    private Group grpLanguagesToTokenize;
    private Text langE;
    private Text tokensE;
    private Label label_2;
    private Label languages;
    private Label tokens;

    public OptionsTab(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.grpTokenizeInThe = new Group((Composite)this, 0);
        this.grpTokenizeInThe.setText("General");
        this.grpTokenizeInThe.setToolTipText("");
        this.grpTokenizeInThe.setLayout((Layout)new GridLayout(3, false));
        this.grpTokenizeInThe.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.grpTokenizeInThe.setData("name", (Object)"grpTokenizeInThe");
        this.source = new Button((Composite)this.grpTokenizeInThe, 32);
        this.source.setData("name", (Object)"source");
        this.source.setText("Tokenize source");
        this.label_2 = new Label((Composite)this.grpTokenizeInThe, 0);
        GridData gridData_4 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData_4.widthHint = 100;
        this.label_2.setLayoutData((Object)gridData_4);
        this.label_2.setData("name", (Object)"label_2");
        this.targets = new Button((Composite)this.grpTokenizeInThe, 32);
        this.targets.setData("name", (Object)"targets");
        this.targets.setText("Tokenize targets");
        this.grpLanguagesToTokenize = new Group((Composite)this, 0);
        this.grpLanguagesToTokenize.setText("Languages");
        this.grpLanguagesToTokenize.setLayout((Layout)new GridLayout(2, false));
        this.grpLanguagesToTokenize.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.languages = new Label((Composite)this.grpLanguagesToTokenize, 0);
        this.languages.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.languages.setData("name", (Object)"languages");
        this.languages.setText("Select languages, or specify a locale filter string (empty = all languages):");
        this.langE = new Text((Composite)this.grpLanguagesToTokenize, 2048);
        GridData gridData_2 = new GridData(4, 0x1000000, true, false, 1, 1);
        gridData_2.widthHint = 311;
        this.langE.setLayoutData((Object)gridData_2);
        this.langE.setData("name", (Object)"langE");
        this.langE.addVerifyListener(e -> {
            e.text = e.text.toLowerCase();
        });
        this.langC = new Button((Composite)this.grpLanguagesToTokenize, 0);
        GridData gridData_1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData_1.widthHint = 70;
        this.langC.setLayoutData((Object)gridData_1);
        this.langC.setData("name", (Object)"langC");
        this.langC.setText("Select...");
        Group grpTokensToCapture = new Group((Composite)this, 0);
        grpTokensToCapture.setText("Tokens");
        grpTokensToCapture.setLayout((Layout)new GridLayout(2, false));
        GridData gridData_3 = new GridData(4, 4, true, true, 1, 1);
        gridData_3.heightHint = 100;
        gridData_3.widthHint = 500;
        grpTokensToCapture.setLayoutData((Object)gridData_3);
        this.tokens = new Label((Composite)grpTokensToCapture, 0);
        this.tokens.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.tokens.setData("name", (Object)"tokens");
        this.tokens.setText("Select tokens to extract (empty = all tokens):");
        this.tokensE = new Text((Composite)grpTokensToCapture, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        gridData.widthHint = 296;
        this.tokensE.setLayoutData((Object)gridData);
        this.tokensE.setData("name", (Object)"tokensE");
        this.tokensE.addVerifyListener(e -> {
            e.text = e.text.toUpperCase();
        });
        this.tokensC = new Button((Composite)grpTokensToCapture, 0);
        GridData gridData_12 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData_12.widthHint = 70;
        this.tokensC.setLayoutData((Object)gridData_12);
        this.tokensC.setData("name", (Object)"tokensC");
        this.tokensC.setText("Select...");
    }

    protected void checkSubclass() {
    }

    public boolean canClose(boolean isOK) {
        return true;
    }

    public void interop(Widget speaker) {
        if (speaker == this.source && (SWTUtil.getNotSelected((Control)this.targets) || SWTUtil.getDisabled((Control)this.targets)) && SWTUtil.getNotSelected((Control)this.source)) {
            Dialogs.showWarning((Shell)this.getShell(), (String)"You cannot unselect this check-box, otherwise there's noting to tokenize.", null);
            SWTUtil.setSelected((Control)this.source, (boolean)true);
        }
        if (speaker == this.targets && (SWTUtil.getNotSelected((Control)this.source) || SWTUtil.getDisabled((Control)this.source)) && SWTUtil.getNotSelected((Control)this.targets)) {
            Dialogs.showWarning((Shell)this.getShell(), (String)"You cannot unselect this check-box, otherwise there's noting to tokenize.", null);
            SWTUtil.setSelected((Control)this.targets, (boolean)true);
        }
        if (speaker == this.langC) {
            String explicitLocales = LocaleFilter.getExplicitLocaleIds((String)this.langE.getText());
            if (!Util.isEmpty((String)explicitLocales)) {
                SWTUtil.setText((Control)this.langE, (String)explicitLocales);
            }
            String res = ListUtil.arrayAsString((String[])LanguageSelector.select(this.getShell(), LanguageSelectorPePage.class, explicitLocales), (String)" ");
            if (Util.isEmpty((String)explicitLocales) && !Util.isEmpty((String)this.langE.getText())) {
                if (!Util.isEmpty((String)res)) {
                    SWTUtil.setText((Control)this.langE, (String)(this.langE.getText() + " " + res));
                }
            } else {
                SWTUtil.setText((Control)this.langE, (String)res);
            }
            this.langE.setFocus();
            this.langE.setSelection(this.langE.getText().length());
        }
        if (speaker == this.tokensC) {
            String[] res = TokenSelector.select(this.getShell(), TokenSelectorPePage.class, this.tokensE.getText());
            SWTUtil.setText((Control)this.tokensE, (String)ListUtil.arrayAsString((String[])res));
            this.tokensE.setFocus();
        }
    }

    public boolean load(Object data) {
        if (data instanceof Parameters) {
            Parameters params = (Parameters)data;
            SWTUtil.setSelected((Control)this.source, (boolean)params.tokenizeSource);
            SWTUtil.setSelected((Control)this.targets, (boolean)params.tokenizeTargets);
            SWTUtil.setText((Control)this.langE, (String)params.getLanguages());
            SWTUtil.setText((Control)this.tokensE, (String)ListUtil.listAsString((List)params.getTokenNames()));
        }
        SWTUtil.addSpeakers((Composite)this, (Control[])new Control[]{this.source, this.targets, this.langC, this.langE, this.tokensC, this.tokensE});
        this.langE.setFocus();
        return true;
    }

    public boolean save(Object data) {
        if (data instanceof Parameters) {
            Parameters params = (Parameters)data;
            params.tokenizeSource = SWTUtil.getSelected((Control)this.source);
            params.tokenizeTargets = SWTUtil.getSelected((Control)this.targets);
            params.setLocaleFilter(this.langE.getText());
            params.setTokenNames(ListUtil.stringAsArray((String)this.tokensE.getText(), (String)" "));
        }
        return true;
    }
}

