/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.ui.locale;

import java.util.ArrayList;
import net.sf.okapi.common.ui.abstracteditor.AbstractBaseDialog;
import net.sf.okapi.common.ui.abstracteditor.IDialogPage;
import net.sf.okapi.common.ui.abstracteditor.TableAdapter;
import net.sf.okapi.lib.extra.INotifiable;
import net.sf.okapi.steps.tokenization.locale.LanguageList;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class LanguageSelectorPage
extends Composite
implements IDialogPage {
    protected Label listDescr;
    private Table table;
    private TableColumn col1;
    private TableColumn col2;
    private TableAdapter adapter;
    private TableColumn col3;

    public LanguageSelectorPage(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.listDescr = new Label((Composite)this, 0);
        this.listDescr.setData("name", (Object)"listDescr");
        this.listDescr.setText("The program displays installed languages and their codes.");
        this.table = new Table((Composite)this, 67584);
        if (this.hasCheckBoxes()) {
            this.table.dispose();
            this.table = new Table((Composite)this, 67616);
        }
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Shell shell;
                Object parent;
                Object dialog = LanguageSelectorPage.this.getData("dialog");
                if (dialog instanceof AbstractBaseDialog && (parent = (shell = ((AbstractBaseDialog)dialog).getShell()).getData("parent")) != null && dialog instanceof INotifiable) {
                    ((INotifiable)dialog).exec((Object)this, "NOTIFICATION_OK", null);
                }
            }
        });
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.heightHint = 400;
        this.table.setLayoutData((Object)gridData);
        this.table.setData("name", (Object)"table");
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.col1 = new TableColumn(this.table, 0);
        this.col1.setData("name", (Object)"col1");
        this.col1.setWidth(348);
        this.col1.setText("Language");
        this.col2 = new TableColumn(this.table, 0);
        this.col2.setData("name", (Object)"col2");
        this.col2.setWidth(150);
        this.col2.setText("Code Okapi");
        this.adapter = new TableAdapter(this.table);
        this.col3 = new TableColumn(this.table, 0);
        this.col3.setData("name", (Object)"col3");
        this.col3.setWidth(150);
        this.col3.setText("Code CLDR");
        this.adapter.setRelColumnWidths(new double[]{6.0, 1.25, 1.25});
    }

    protected boolean hasCheckBoxes() {
        return false;
    }

    public boolean canClose(boolean isOK) {
        return true;
    }

    public void interop(Widget speaker) {
    }

    public boolean load(Object data) {
        String[] languages = LanguageList.getLanguages();
        String[] codes = LanguageList.getLanguageCodes_Okapi();
        String[] codes2 = LanguageList.getLanguageCodes_ICU();
        for (int i = 0; i < Math.min(languages.length, codes.length); ++i) {
            this.adapter.addRow(new String[]{languages[i], codes[i], codes2[i]}, false);
        }
        this.adapter.sort(1, false);
        if (data instanceof ArrayList) {
            ArrayList list = (ArrayList)data;
            for (String string : list) {
                TableItem item = this.adapter.findValue(string, 2);
                if (item == null) continue;
                item.setChecked(true);
            }
        }
        return true;
    }

    public boolean save(Object data) {
        if (data instanceof ArrayList) {
            ArrayList list = (ArrayList)data;
            list.clear();
            for (TableItem item : this.table.getItems()) {
                if (!item.getChecked()) continue;
                list.add(item.getText(1));
            }
        }
        return true;
    }
}

