/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.textmodification;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.tests.StepTestDriver;
import net.sf.okapi.steps.textmodification.Parameters;
import net.sf.okapi.steps.textmodification.TextModificationStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TextModificationStepTest {
    private StepTestDriver driver;
    private LocaleId locEN = LocaleId.fromString((String)"EN");
    private LocaleId locFR = LocaleId.fromString((String)"Fr");

    @Before
    public void setUp() {
        this.driver = new StepTestDriver();
    }

    @Test
    public void testTargetDefaults() {
        String original = "This is the content #1 with %s.";
        this.driver.prepareFilterEventsStep(original, original, this.locEN, this.locFR);
        TextModificationStep step = new TextModificationStep();
        Parameters params = step.getParameters();
        params.setType(1);
        this.driver.testFilterEventsStep((IPipelineStep)step);
        ITextUnit res = this.driver.getResult();
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)res.hasTarget(this.locFR));
        Assert.assertEquals((Object)original, (Object)res.getTarget(this.locFR).toString());
    }

    @Test
    public void testDefaults() {
        String original = "This is the content.";
        this.driver.prepareFilterEventsStep(original, null, this.locEN, this.locFR);
        TextModificationStep step = new TextModificationStep();
        this.driver.testFilterEventsStep((IPipelineStep)step);
        ITextUnit res = this.driver.getResult();
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)res.hasTarget(this.locFR));
        Assert.assertEquals((Object)original, (Object)res.getTarget(this.locFR).toString());
    }

    @Test
    public void testWithPrefixSuffixMarkers() {
        String original = "This is the content.";
        String expected = "{_[This is the content.]_id1_}";
        this.driver.prepareFilterEventsStep(original, null, this.locEN, this.locFR);
        TextModificationStep step = new TextModificationStep();
        Parameters params = step.getParameters();
        params.setAddPrefix(true);
        params.setPrefix("{_");
        params.setAddSuffix(true);
        params.setSuffix("_}");
        params.setMarkSegments(true);
        params.setAddID(true);
        this.driver.testFilterEventsStep((IPipelineStep)step);
        ITextUnit res = this.driver.getResult();
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)res.hasTarget(this.locFR));
        Assert.assertEquals((Object)expected, (Object)res.getTarget(this.locFR).toString());
    }

    @Test
    public void testWithXandNs() {
        String original = "This is the content #1 with %s.";
        String expected = "Xxxx xx xxx xxxxxxx #N xxxx %x.";
        this.driver.prepareFilterEventsStep(original, null, this.locEN, this.locFR);
        TextModificationStep step = new TextModificationStep();
        Parameters params = step.getParameters();
        params.setType(1);
        this.driver.testFilterEventsStep((IPipelineStep)step);
        ITextUnit res = this.driver.getResult();
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)res.hasTarget(this.locFR));
        Assert.assertEquals((Object)expected, (Object)res.getTarget(this.locFR).toString());
    }

    @Test
    public void testWithPseudoTrans() {
        String original = "This is the content #1 with %s.";
        String expected = "\u0162\u0125\u0129\u015b \u0129\u015b \u0163\u0125\u0113 \u0107\u014d\u0144\u0163\u0113\u0144\u0163 #1 \u0175\u0129\u0163\u0125 %\u015b.";
        this.driver.prepareFilterEventsStep(original, null, this.locEN, this.locFR);
        TextModificationStep step = new TextModificationStep();
        Parameters params = step.getParameters();
        params.setType(3);
        this.driver.testFilterEventsStep((IPipelineStep)step);
        ITextUnit res = this.driver.getResult();
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)res.hasTarget(this.locFR));
        Assert.assertEquals((Object)expected, (Object)res.getTarget(this.locFR).toString());
    }

    @Test
    public void testKeepInlineCodes() {
        String original = "This is the content #1 with '@#$0'.";
        String expected = "@#$0";
        this.driver.prepareFilterEventsStep(original, null, this.locEN, this.locFR);
        TextModificationStep step = new TextModificationStep();
        Parameters params = step.getParameters();
        params.setType(2);
        this.driver.testFilterEventsStep((IPipelineStep)step);
        ITextUnit res = this.driver.getResult();
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)res.hasTarget(this.locFR));
        Assert.assertEquals((Object)expected, (Object)res.getTarget(this.locFR).toString());
    }

    @Test
    public void testExpansion() {
        TextModificationStep step = new TextModificationStep();
        Parameters params = step.getParameters();
        params.setType(0);
        params.setExpand(true);
        String original = "Original.";
        String expected = "Original. zzzz";
        this.driver.prepareFilterEventsStep(original, null, this.locEN, this.locFR);
        this.driver.testFilterEventsStep((IPipelineStep)step);
        ITextUnit res = this.driver.getResult();
        Assert.assertEquals((Object)expected, (Object)res.getTarget(this.locFR).toString());
        original = "O";
        expected = "Oz";
        this.driver.prepareFilterEventsStep(original, null, this.locEN, this.locFR);
        this.driver.testFilterEventsStep((IPipelineStep)step);
        res = this.driver.getResult();
        Assert.assertEquals((Object)expected, (Object)res.getTarget(this.locFR).toString());
        original = "";
        expected = "";
        this.driver.prepareFilterEventsStep(original, null, this.locEN, this.locFR);
        this.driver.testFilterEventsStep((IPipelineStep)step);
        res = this.driver.getResult();
        Assert.assertEquals((Object)expected, (Object)res.getTarget(this.locFR).toString());
        original = "This is a longer text with a lot more words and characters.";
        expected = "This is a longer text with a lot more words and characters. zzzzz zzzzz zzzzz zzzzz zzzzz zzzzz zzzzz zzzzz zzzzz zzzz";
        this.driver.prepareFilterEventsStep(original, null, this.locEN, this.locFR);
        this.driver.testFilterEventsStep((IPipelineStep)step);
        res = this.driver.getResult();
        Assert.assertEquals((Object)expected, (Object)res.getTarget(this.locFR).toString());
    }

    @Test
    public void testTargetOverwriting() {
        String original = "This is the content #1 with @#$0.";
        String expected = "Xxxx xx xxx xxxxxxx #N xxxx @#$0.";
        this.driver.prepareFilterEventsStep(original, original, this.locEN, this.locFR);
        TextModificationStep step = new TextModificationStep();
        Parameters params = step.getParameters();
        params.setType(1);
        params.setApplyToExistingTarget(true);
        this.driver.testFilterEventsStep((IPipelineStep)step);
        ITextUnit res = this.driver.getResult();
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)res.hasTarget(this.locFR));
        Assert.assertEquals((Object)expected, (Object)res.getTarget(this.locFR).toString());
    }
}

