/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.termextraction;

import java.io.File;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.steps.termextraction.Parameters;
import net.sf.okapi.steps.termextraction.SimpleTermExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class TermExtractionStep
extends BasePipelineStep {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Parameters params = new Parameters();
    private SimpleTermExtractor extractor = new SimpleTermExtractor();
    private LocaleId sourceLocale;
    private String rootDir;
    private String inputRootDir;

    public String getName() {
        return "Term Extraction";
    }

    public String getDescription() {
        return "Extract a list of possible terms found in the source content. Expects: filter events. Sends back: filter events.";
    }

    public Parameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourcetLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    protected Event handleStartBatch(Event event) {
        this.extractor.initialize(this.params, this.sourceLocale, this.rootDir, this.inputRootDir);
        return event;
    }

    protected Event handleTextUnit(Event event) {
        this.extractor.processTextUnit(event.getTextUnit());
        return event;
    }

    protected Event handleEndBatch(Event event) {
        this.extractor.completeExtraction();
        String finalPath = Util.fillRootDirectoryVariable((String)this.params.getOutputPath(), (String)this.rootDir);
        this.LOGGER.info("Output: {}", (Object)finalPath);
        this.LOGGER.info("Candidate terms found = {}", (Object)this.extractor.getTerms().size());
        if (this.params.getAutoOpen()) {
            Util.openURL((String)new File(finalPath).getAbsolutePath());
        }
        return event;
    }
}

