/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.scopingreport;

import java.io.File;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileCompare;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.connectors.pensieve.PensieveTMConnector;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.plaintext.PlainTextFilter;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatch;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatchItem;
import net.sf.okapi.lib.extra.pipelinebuilder.XParameter;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipeline;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipelineStep;
import net.sf.okapi.lib.extra.steps.EventLogger;
import net.sf.okapi.lib.extra.steps.TextUnitLogger;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.leveraging.LeveragingStep;
import net.sf.okapi.steps.repetitionanalysis.RepetitionAnalysisStep;
import net.sf.okapi.steps.scopingreport.Parameters;
import net.sf.okapi.steps.scopingreport.ScopingReportStep;
import net.sf.okapi.steps.segmentation.SegmentationStep;
import net.sf.okapi.steps.wordcount.CharacterCountStep;
import net.sf.okapi.steps.wordcount.SimpleWordCountStep;
import net.sf.okapi.steps.wordcount.WordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactLocalContextMatchWordCountStep;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class TestScopingReport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final LocaleId EN = new LocaleId("en", "us");
    private static final LocaleId ES = new LocaleId("es", "es");
    private static final LocaleId DE = new LocaleId("de", "de");
    private FileLocation root;

    @Before
    public void setUp() {
        this.root = FileLocation.fromClass(this.getClass());
    }

    public static void testPath(String path) {
        Logger localLogger = LoggerFactory.getLogger(TestScopingReport.class);
        localLogger.debug(new File(path).getAbsolutePath());
    }

    @Test
    public void testDefaultTemplate() {
        ScopingReportStep srs = new ScopingReportStep();
        Parameters params = (Parameters)srs.getParameters();
        Assert.assertEquals((Object)"My Project", (Object)params.getProjectName());
        Assert.assertEquals((Object)"", (Object)params.getCustomTemplateURI());
        Assert.assertTrue((boolean)params.useDefaultTemplate());
        Assert.assertTrue((boolean)params.useTemplateFile());
        new XPipeline("HTML report test", new XBatch(new XBatchItem[]{new XBatchItem(this.root.in("aa324.html").asUrl(), "UTF-8", EN, ES), new XBatchItem(this.root.in("form.html").asUrl(), "UTF-8", EN, DE)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new EventLogger(), new WordCountStep(), new XPipelineStep((IPipelineStep)srs, new XParameter[]{new XParameter("outputPath", this.root.out("test_custom_template_report.html").toString())})}).execute();
        this.logger.debug(this.root.out("/").toString());
        Assert.assertEquals((Object)"My Project", (Object)params.getProjectName());
        Assert.assertEquals((Object)"", (Object)params.getCustomTemplateURI());
    }

    @Test
    public void testDefaultTemplateSWCS() {
        ScopingReportStep srs = new ScopingReportStep();
        Parameters params = (Parameters)srs.getParameters();
        Assert.assertEquals((Object)"My Project", (Object)params.getProjectName());
        Assert.assertEquals((Object)"", (Object)params.getCustomTemplateURI());
        Assert.assertTrue((boolean)params.useDefaultTemplate());
        Assert.assertTrue((boolean)params.useTemplateFile());
        new XPipeline("HTML report test", new XBatch(new XBatchItem[]{new XBatchItem(this.root.in("aa324.html").asUri(), "UTF-8", EN, ES), new XBatchItem(this.root.in("form.html").asUri(), "UTF-8", EN, ES)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new EventLogger(), new SimpleWordCountStep(), new XPipelineStep((IPipelineStep)srs, new XParameter[]{new XParameter("outputPath", this.root.out("test_custom_template_report.html").toString())})}).execute();
        this.logger.debug(this.root.out("/").toString());
        Assert.assertEquals((Object)"My Project", (Object)params.getProjectName());
        Assert.assertEquals((Object)"", (Object)params.getCustomTemplateURI());
    }

    @Test
    public void testCustomTemplateSWCS() {
        String path = this.root.in("/totals_report_template.html").toString();
        ScopingReportStep srs = new ScopingReportStep();
        Parameters params = (Parameters)srs.getParameters();
        params.setCustomTemplateURI(path);
        Assert.assertTrue((boolean)params.useTemplateFile());
        Assert.assertEquals((Object)"My Project", (Object)params.getProjectName());
        Assert.assertEquals((Object)path, (Object)params.getCustomTemplateURI());
        new XPipeline("HTML report test", new XBatch(new XBatchItem[]{new XBatchItem(this.root.in("test0.txt").asUri(), "UTF-8", EN, ES), new XBatchItem(this.root.in("aa324.html").asUri(), "UTF-8", EN, ES), new XBatchItem(this.root.in("form.html").asUri(), "UTF-8", EN, DE)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new EventLogger(), new SimpleWordCountStep(), new XPipelineStep((IPipelineStep)srs, new XParameter[]{new XParameter("outputPath", this.root.out("totals_report.html").toString())})}).execute();
        this.logger.debug(this.root.out("/").toString());
        Assert.assertEquals((Object)"My Project", (Object)params.getProjectName());
        Assert.assertEquals((Object)path, (Object)params.getCustomTemplateURI());
    }

    @Test
    public void testCustomTemplate() {
        ScopingReportStep srs = new ScopingReportStep();
        Parameters params = (Parameters)srs.getParameters();
        Assert.assertEquals((Object)"", (Object)params.getCustomTemplateURI());
        params.setProjectName("Test scoping report");
        String path = this.root.in("test_scoping_report.html").toString();
        Assert.assertNotNull((Object)path);
        params.setCustomTemplateURI(path);
        Assert.assertFalse((boolean)params.useDefaultTemplate());
        Assert.assertTrue((boolean)params.useTemplateFile());
        Assert.assertEquals((Object)"test_scoping_report.html", (Object)Util.getFilename((String)path, (boolean)true));
        XPipeline pipeline = new XPipeline("HTML report test", new XBatch(new XBatchItem[]{new XBatchItem(this.root.in("aa324.html").asUrl(), "UTF-8", EN, ES), new XBatchItem(this.root.in("form.html").asUrl(), "UTF-8", EN, ES)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new EventLogger(), new XPipelineStep((IPipelineStep)srs, new XParameter[]{new XParameter("outputPath", this.root.out("test_custom_template_report.html").toString())})});
        Assert.assertEquals((Object)"Test scoping report", (Object)params.getProjectName());
        Assert.assertEquals((Object)"test_scoping_report.html", (Object)Util.getFilename((String)params.getCustomTemplateURI(), (boolean)true));
        pipeline.execute();
        this.logger.debug(this.root.out("/").toString());
        Assert.assertEquals((Object)"Test scoping report", (Object)params.getProjectName());
        Assert.assertEquals((Object)"test_scoping_report.html", (Object)Util.getFilename((String)params.getCustomTemplateURI(), (boolean)true));
    }

    @Test
    public void testCustomStringTemplateSWCS() {
        ScopingReportStep srs = new ScopingReportStep();
        Parameters params = (Parameters)srs.getParameters();
        Assert.assertEquals((Object)"", (Object)params.getCustomTemplateString());
        String template = "  Total: [PROJECT_TOTAL_WORD_COUNT]\n  Exact Local Context: [PROJECT_EXACT_LOCAL_CONTEXT]\n  100% Match: [PROJECT_GMX_LEVERAGED_MATCHED_WORD_COUNT]\n  Fuzzy Match: [PROJECT_GMX_FUZZY_MATCHED_WORD_COUNT]\n  Repetitions: [PROJECT_GMX_REPETITION_MATCHED_WORD_COUNT]\n";
        params.setCustomTemplateString(template);
        params.setOutputPath(null);
        Assert.assertFalse((boolean)params.useDefaultTemplate());
        Assert.assertFalse((boolean)params.useTemplateFile());
        XPipeline pipeline = new XPipeline("String report test", new XBatch(new XBatchItem[]{new XBatchItem(this.root.in("aa324.html").asUrl(), "UTF-8", EN, ES), new XBatchItem(this.root.in("form.html").asUrl(), "UTF-8", EN, ES)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new EventLogger(), new SimpleWordCountStep(), new XPipelineStep((IPipelineStep)srs, new XParameter[]{new XParameter("outputPath", "")})});
        pipeline.execute();
        Assert.assertEquals((Object)"  Total: 420\n  Exact Local Context: 0\n  100% Match: 0\n  Fuzzy Match: 0\n  Repetitions: 0\n", (Object)srs.getReportGenerator().generate());
    }

    @Test
    public void htmlReportTest() {
        new XPipeline("HTML report test", new XBatch(new XBatchItem[]{new XBatchItem(this.root.in("aa324.html").asUrl(), "UTF-8", EN, ES), new XBatchItem(this.root.in("form.html").asUrl(), "UTF-8", EN, ES)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new EventLogger(), new XPipelineStep((IPipelineStep)new ScopingReportStep(), new XParameter[]{new XParameter("outputPath", this.root.out("test_scoping_report.html").toString())})}).execute();
        this.logger.debug(this.root.out("/").toString());
    }

    @Test
    public void htmlReportTest2() {
        StartDocument sd1 = new StartDocument("sd1");
        sd1.setName(this.root.in("aa324.html").toString());
        StartDocument sd2 = new StartDocument("sd2");
        sd2.setName(this.root.in("form.html").toString());
        ScopingReportStep srs = new ScopingReportStep();
        Parameters params = (Parameters)srs.getParameters();
        params.setProjectName("Test scoping report");
        params.setOutputPath(this.root.out("test_scoping_report2.html").toString());
        srs.setSourceLocale(EN);
        srs.setTargetLocale(ES);
        srs.handleEvent(new Event(EventType.START_BATCH));
        srs.handleEvent(new Event(EventType.START_DOCUMENT, (IResource)sd1));
        srs.handleEvent(new Event(EventType.START_DOCUMENT, (IResource)sd2));
        Ending res = new Ending("end_batch");
        MetricsAnnotation ma = new MetricsAnnotation();
        res.setAnnotation((IAnnotation)ma);
        Metrics m = ma.getMetrics();
        m.setMetric("TotalWordCount", 1273L);
        m.setMetric(ExactLocalContextMatchWordCountStep.METRIC, 72L);
        m.setMetric("ExactMatchedWordCount", 120L);
        m.setMetric("LeveragedMatchedWordCount", 132L);
        m.setMetric("FuzzyMatchedWordCount", 781L);
        m.setMetric("RepetitionMatchedWordCount", 112L);
        srs.handleEvent(new Event(EventType.END_BATCH, (IResource)res));
        this.logger.debug(this.root.out("test_scoping_report2.html").toString());
    }

    @Test
    public void testLeveraging() {
        net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
        params.setDbDirectory(this.root.in("testtm").toString());
        new XPipeline("HTML report test", new XBatch(new XBatchItem[]{new XBatchItem(this.root.in("test.txt").asUrl(), "UTF-8", EN, ES)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new PlainTextFilter()), new EventLogger(), new XPipelineStep((IPipelineStep)new SegmentationStep(), new XParameter[]{new XParameter("sourceSrxPath", this.root.in("default.srx").toString()), new XParameter("trimSrcLeadingWS", net.sf.okapi.steps.segmentation.Parameters.TRIM_YES), new XParameter("trimSrcTrailingWS", net.sf.okapi.steps.segmentation.Parameters.TRIM_YES)}), new XPipelineStep((IPipelineStep)new LeveragingStep(), new XParameter[]{new XParameter("resourceClassName", PensieveTMConnector.class.getName()), new XParameter("resourceParameters", params.toString(), true), new XParameter("threshold", 60), new XParameter("fillTarget", true)}), new WordCountStep(), new TextUnitLogger(), new XPipelineStep((IPipelineStep)new ScopingReportStep(), new XParameter[]{new XParameter("projectName", "Test Scoping Report"), new XParameter("outputPath", this.root.out("test_scoping_report3.html").toString())})}).execute();
        this.logger.debug(this.root.out("/").toString());
    }

    @Test
    public void test_a_word_is_counted_only_once() {
        net.sf.okapi.connectors.pensieve.Parameters rparams = new net.sf.okapi.connectors.pensieve.Parameters();
        rparams.setDbDirectory(this.root.in("testtm").toString());
        String outputFilePath = this.root.out("test_scoping_report4.txt").toString();
        String goldFilePath = this.root.in("gold/test_scoping_report4.txt").toString();
        Event sbEvent = new Event(EventType.START_BATCH);
        Event ebEvent = new Event(EventType.END_BATCH);
        Event siEvent = new Event(EventType.START_BATCH_ITEM);
        Event eiEvent = new Event(EventType.END_BATCH_ITEM);
        StartDocument sd = new StartDocument("sd");
        sd.setLocale(LocaleId.ENGLISH);
        Event sdEvent = new Event(EventType.START_DOCUMENT, (IResource)sd);
        Ending ed = new Ending("ed");
        Event edEvent = new Event(EventType.END_DOCUMENT, (IResource)ed);
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSource(new TextContainer("Elephants cannot fly."));
        Event tuEvent1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        TextUnit tu2 = new TextUnit("tu2");
        tu2.setSource(new TextContainer("Elephants can't fly."));
        Event tuEvent2 = new Event(EventType.TEXT_UNIT, (IResource)tu2);
        TextUnit tu3 = new TextUnit("tu3");
        tu3.setSource(new TextContainer("Elephants can fly."));
        Event tuEvent3 = new Event(EventType.TEXT_UNIT, (IResource)tu3);
        TextUnit tu4 = new TextUnit("tu4");
        tu4.setSource(new TextContainer("Airplanes can fly."));
        Event tuEvent4 = new Event(EventType.TEXT_UNIT, (IResource)tu4);
        LeveragingStep ls = new LeveragingStep();
        ls.setSourceLocale(LocaleId.ENGLISH);
        ls.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.leveraging.Parameters params = ls.getParameters();
        params.setResourceParameters(rparams.toString());
        params.setResourceClassName(PensieveTMConnector.class.getName());
        params.setThreshold(60);
        params.setFillTarget(true);
        WordCountStep wcs = new WordCountStep();
        ScopingReportStep srs = new ScopingReportStep();
        srs.setSourceLocale(LocaleId.ENGLISH);
        srs.setTargetLocale(LocaleId.FRENCH);
        Parameters params2 = (Parameters)srs.getParameters();
        params2.setOutputPath(outputFilePath);
        params2.setCustomTemplateURI(this.root.in("golden_file_template.txt").toString());
        sd.setName(params2.getCustomTemplateURI());
        wcs.handleEvent(sbEvent);
        wcs.handleEvent(siEvent);
        wcs.handleEvent(sdEvent);
        wcs.handleEvent(tuEvent1);
        wcs.handleEvent(tuEvent2);
        wcs.handleEvent(tuEvent3);
        wcs.handleEvent(tuEvent4);
        wcs.handleEvent(edEvent);
        wcs.handleEvent(eiEvent);
        wcs.handleEvent(ebEvent);
        ls.handleEvent(sbEvent);
        ls.handleEvent(siEvent);
        ls.handleEvent(sdEvent);
        ls.handleEvent(tuEvent1);
        ls.handleEvent(tuEvent2);
        ls.handleEvent(tuEvent3);
        ls.handleEvent(tuEvent4);
        ls.handleEvent(edEvent);
        ls.handleEvent(eiEvent);
        ls.handleEvent(ebEvent);
        srs.handleEvent(sbEvent);
        srs.handleEvent(siEvent);
        srs.handleEvent(sdEvent);
        srs.handleEvent(tuEvent1);
        srs.handleEvent(tuEvent2);
        srs.handleEvent(tuEvent3);
        srs.handleEvent(tuEvent4);
        srs.handleEvent(edEvent);
        srs.handleEvent(eiEvent);
        srs.handleEvent(ebEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu1, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu2, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu3, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu4, (LocaleId)LocaleId.ENGLISH));
        TestScopingReport.testPath(outputFilePath);
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(outputFilePath, goldFilePath, "ISO-8859-1"));
    }

    @Test
    public void test_a_word_is_counted_only_once2() {
        net.sf.okapi.connectors.pensieve.Parameters rparams = new net.sf.okapi.connectors.pensieve.Parameters();
        rparams.setDbDirectory(this.root.in("testtm").toString());
        String outputFilePath = this.root.out("test_scoping_report5.txt").toString();
        String goldFilePath = this.root.in("gold/test_scoping_report5.txt").toString();
        Event sbEvent = new Event(EventType.START_BATCH);
        Event ebEvent = new Event(EventType.END_BATCH);
        Event siEvent = new Event(EventType.START_BATCH_ITEM);
        Event eiEvent = new Event(EventType.END_BATCH_ITEM);
        StartDocument sd = new StartDocument("sd");
        sd.setLocale(LocaleId.ENGLISH);
        Event sdEvent = new Event(EventType.START_DOCUMENT, (IResource)sd);
        Ending ed = new Ending("ed");
        Event edEvent = new Event(EventType.END_DOCUMENT, (IResource)ed);
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSource(new TextContainer("Elephants cannot fly."));
        Event tuEvent1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        TextUnit tu2 = new TextUnit("tu2");
        tu2.setSource(new TextContainer("Elephants can't fly."));
        Event tuEvent2 = new Event(EventType.TEXT_UNIT, (IResource)tu2);
        TextUnit tu3 = new TextUnit("tu3");
        tu3.setSource(new TextContainer("Elephants can fly."));
        Event tuEvent3 = new Event(EventType.TEXT_UNIT, (IResource)tu3);
        TextUnit tu4 = new TextUnit("tu4");
        tu4.setSource(new TextContainer("Airplanes can fly."));
        Event tuEvent4 = new Event(EventType.TEXT_UNIT, (IResource)tu4);
        LeveragingStep ls = new LeveragingStep();
        ls.setSourceLocale(LocaleId.ENGLISH);
        ls.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.leveraging.Parameters params = ls.getParameters();
        params.setResourceParameters(rparams.toString());
        params.setResourceClassName(PensieveTMConnector.class.getName());
        params.setThreshold(60);
        params.setFillTarget(true);
        WordCountStep wcs = new WordCountStep();
        ScopingReportStep srs = new ScopingReportStep();
        srs.setSourceLocale(LocaleId.ENGLISH);
        srs.setTargetLocale(LocaleId.FRENCH);
        Parameters params2 = (Parameters)srs.getParameters();
        params2.setOutputPath(outputFilePath);
        params2.setCustomTemplateURI(this.root.in("golden_file_template.txt").toString());
        params2.setCountAsNonTranslatable_ExactMatch(true);
        params2.setCountAsNonTranslatable_GMXFuzzyMatch(true);
        sd.setName(params2.getCustomTemplateURI());
        wcs.handleEvent(sbEvent);
        wcs.handleEvent(siEvent);
        wcs.handleEvent(sdEvent);
        wcs.handleEvent(tuEvent1);
        wcs.handleEvent(tuEvent2);
        wcs.handleEvent(tuEvent3);
        wcs.handleEvent(tuEvent4);
        wcs.handleEvent(edEvent);
        wcs.handleEvent(eiEvent);
        wcs.handleEvent(ebEvent);
        ls.handleEvent(sbEvent);
        ls.handleEvent(siEvent);
        ls.handleEvent(sdEvent);
        ls.handleEvent(tuEvent1);
        ls.handleEvent(tuEvent2);
        ls.handleEvent(tuEvent3);
        ls.handleEvent(tuEvent4);
        ls.handleEvent(edEvent);
        ls.handleEvent(eiEvent);
        ls.handleEvent(ebEvent);
        srs.handleEvent(sbEvent);
        srs.handleEvent(siEvent);
        srs.handleEvent(sdEvent);
        srs.handleEvent(tuEvent1);
        srs.handleEvent(tuEvent2);
        srs.handleEvent(tuEvent3);
        srs.handleEvent(tuEvent4);
        srs.handleEvent(edEvent);
        srs.handleEvent(eiEvent);
        srs.handleEvent(ebEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu1, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu2, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu3, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu4, (LocaleId)LocaleId.ENGLISH));
        TestScopingReport.testPath(outputFilePath);
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(outputFilePath, goldFilePath, "ISO-8859-1"));
    }

    @Test
    public void test_repetitions() {
        String outputFilePath = this.root.out("test_scoping_report6.txt").toString();
        String goldFilePath = this.root.in("gold/test_scoping_report6.txt").toString();
        Event sbEvent = new Event(EventType.START_BATCH);
        Event ebEvent = new Event(EventType.END_BATCH);
        Event siEvent = new Event(EventType.START_BATCH_ITEM);
        Event eiEvent = new Event(EventType.END_BATCH_ITEM);
        StartDocument sd = new StartDocument("sd");
        sd.setLocale(LocaleId.ENGLISH);
        Event sdEvent = new Event(EventType.START_DOCUMENT, (IResource)sd);
        Ending ed = new Ending("ed");
        Event edEvent = new Event(EventType.END_DOCUMENT, (IResource)ed);
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSource(new TextContainer("Elephants cannot fly."));
        Event tuEvent1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        TextUnit tu2 = new TextUnit("tu2");
        tu2.setSource(new TextContainer("Elephants cannot fly."));
        Event tuEvent2 = new Event(EventType.TEXT_UNIT, (IResource)tu2);
        TextUnit tu3 = new TextUnit("tu3");
        tu3.setSource(new TextContainer("Elephants can fly."));
        Event tuEvent3 = new Event(EventType.TEXT_UNIT, (IResource)tu3);
        TextUnit tu4 = new TextUnit("tu4");
        tu4.setSource(new TextContainer("Airplanes can fly."));
        Event tuEvent4 = new Event(EventType.TEXT_UNIT, (IResource)tu4);
        RepetitionAnalysisStep ras = new RepetitionAnalysisStep();
        net.sf.okapi.steps.repetitionanalysis.Parameters params = ras.getParameters();
        params.setFuzzyThreshold(10);
        ras.setSourceLocale(LocaleId.ENGLISH);
        ras.setTargetLocale(LocaleId.FRENCH);
        WordCountStep wcs = new WordCountStep();
        CharacterCountStep ccs = new CharacterCountStep();
        ScopingReportStep srs = new ScopingReportStep();
        srs.setSourceLocale(LocaleId.ENGLISH);
        srs.setTargetLocale(LocaleId.FRENCH);
        Parameters params2 = (Parameters)srs.getParameters();
        params2.setOutputPath(outputFilePath);
        params2.setCustomTemplateURI(this.root.in("golden_file_template2.txt").toString());
        sd.setName(params2.getCustomTemplateURI());
        ras.handleEvent(sbEvent);
        ras.handleEvent(siEvent);
        ras.handleEvent(sdEvent);
        ras.handleEvent(tuEvent1);
        ras.handleEvent(tuEvent2);
        ras.handleEvent(tuEvent3);
        ras.handleEvent(tuEvent4);
        ras.handleEvent(edEvent);
        ras.handleEvent(eiEvent);
        ras.handleEvent(ebEvent);
        wcs.handleEvent(sbEvent);
        wcs.handleEvent(siEvent);
        wcs.handleEvent(sdEvent);
        wcs.handleEvent(tuEvent1);
        wcs.handleEvent(tuEvent2);
        wcs.handleEvent(tuEvent3);
        wcs.handleEvent(tuEvent4);
        wcs.handleEvent(edEvent);
        wcs.handleEvent(eiEvent);
        wcs.handleEvent(ebEvent);
        ccs.handleEvent(sbEvent);
        ccs.handleEvent(siEvent);
        ccs.handleEvent(sdEvent);
        ccs.handleEvent(tuEvent1);
        ccs.handleEvent(tuEvent2);
        ccs.handleEvent(tuEvent3);
        ccs.handleEvent(tuEvent4);
        ccs.handleEvent(edEvent);
        ccs.handleEvent(eiEvent);
        ccs.handleEvent(ebEvent);
        srs.handleEvent(sbEvent);
        srs.handleEvent(siEvent);
        srs.handleEvent(sdEvent);
        srs.handleEvent(tuEvent1);
        srs.handleEvent(tuEvent2);
        srs.handleEvent(tuEvent3);
        srs.handleEvent(tuEvent4);
        srs.handleEvent(edEvent);
        srs.handleEvent(eiEvent);
        srs.handleEvent(ebEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu1, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu2, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu3, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu4, (LocaleId)LocaleId.ENGLISH));
        TestScopingReport.testPath(outputFilePath);
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(outputFilePath, goldFilePath, "ISO-8859-1"));
    }
}

