/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.repetitionanalysis;

import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinebuilder.XBatch;
import net.sf.okapi.common.pipelinebuilder.XBatchItem;
import net.sf.okapi.common.pipelinebuilder.XParameter;
import net.sf.okapi.common.pipelinebuilder.XPipeline;
import net.sf.okapi.common.pipelinebuilder.XPipelineStep;
import net.sf.okapi.filters.plaintext.PlainTextFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.repetitionanalysis.RepetitionAnalysisStep;
import net.sf.okapi.steps.segmentation.Parameters;
import net.sf.okapi.steps.segmentation.SegmentationStep;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestRepetitionAnalysisStep {
    FileLocation root = FileLocation.fromClass(this.getClass());

    @Test
    public void testExactRepetitions() {
        String fname = "test1.txt";
        new XPipeline("Test pipeline for repetition analysis step", new XBatch(new XBatchItem[]{new XBatchItem(this.root.in(fname).asUrl(), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new PlainTextFilter()), new XPipelineStep((IPipelineStep)new SegmentationStep(), new XParameter[]{new XParameter("copySource", true), new XParameter("sourceSrxPath", this.root.in("default.srx").toString()), new XParameter("trimSrcLeadingWS", Parameters.TRIM_YES), new XParameter("trimSrcTrailingWS", Parameters.TRIM_YES)}), new RepetitionAnalysisStep()}).execute();
    }

    @Test
    public void testFuzzyRepetitions() {
        String fname = "test1.txt";
        new XPipeline("Test pipeline for repetition analysis step", new XBatch(new XBatchItem[]{new XBatchItem(this.root.in(fname).asUrl(), "UTF-8", LocaleId.ENGLISH, LocaleId.GERMAN)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new PlainTextFilter()), new XPipelineStep((IPipelineStep)new SegmentationStep(), new XParameter[]{new XParameter("copySource", true), new XParameter("sourceSrxPath", this.root.in("default.srx").toString()), new XParameter("trimSrcLeadingWS", Parameters.TRIM_YES), new XParameter("trimSrcTrailingWS", Parameters.TRIM_YES)}), new XPipelineStep((IPipelineStep)new RepetitionAnalysisStep(), new XParameter[]{new XParameter("fuzzyThreshold", 40)})}).execute();
    }

    @Test
    public void testMissingTargetInBilingualFile() {
        String fname = "bilingual_missing_target.xlf";
        new XPipeline("Test pipeline for repetition analysis step", new XBatch(new XBatchItem[]{new XBatchItem(this.root.in(fname).asUrl(), "UTF-8", LocaleId.ENGLISH, LocaleId.SPANISH)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new XLIFFFilter()), new XPipelineStep((IPipelineStep)new SegmentationStep(), new XParameter[]{new XParameter("copySource", true), new XParameter("sourceSrxPath", this.root.in("default.srx").toString()), new XParameter("trimSrcLeadingWS", Parameters.TRIM_YES), new XParameter("trimSrcTrailingWS", Parameters.TRIM_YES)}), new RepetitionAnalysisStep()}).execute();
    }
}

