/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.repetitionanalysis;

import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TmHit;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import net.sf.okapi.tm.pensieve.seeker.ITmSeeker;
import net.sf.okapi.tm.pensieve.seeker.TmSeekerFactory;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.TmWriterFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestPensieveWriterSeeker {
    private String tmDir;
    private ITmWriter tmWriter;
    private ITmSeeker currentTm;

    @Before
    public void setup() {
        this.tmDir = Util.ensureSeparator((String)Util.getTempDirectory(), (boolean)true) + "tm/";
        Util.createDirectories((String)this.tmDir);
        this.tmWriter = TmWriterFactory.createFileBasedTmWriter((String)this.tmDir, (boolean)true);
        this.currentTm = TmSeekerFactory.createFileBasedTmSeeker((String)this.tmDir);
    }

    @After
    public void shutdown() {
        this.currentTm.close();
        this.tmWriter.close();
        Util.deleteDirectory((String)this.tmDir, (boolean)false);
    }

    @Test
    public void testTmReadWrite() {
        TranslationUnit unit1 = new TranslationUnit(new TranslationUnitVariant(LocaleId.ENGLISH, new TextFragment("source1")), new TranslationUnitVariant(LocaleId.GERMAN, new TextFragment("target1")));
        unit1.setMetadataValue(MetadataType.ID, "seg1");
        this.tmWriter.indexTranslationUnit(unit1);
        TranslationUnit unit2 = new TranslationUnit(new TranslationUnitVariant(LocaleId.ENGLISH, new TextFragment("source2")), new TranslationUnitVariant(LocaleId.GERMAN, new TextFragment("target2")));
        unit2.setMetadataValue(MetadataType.ID, "seg2");
        this.tmWriter.indexTranslationUnit(unit2);
        this.tmWriter.commit();
        List hits = this.currentTm.searchExact(new TextFragment("source1"), null);
        Assert.assertEquals((long)1L, (long)hits.size());
        TmHit hit = (TmHit)hits.get(0);
        Assert.assertEquals((Object)"seg1", (Object)hit.getTu().getMetadataValue(MetadataType.ID));
        hits = this.currentTm.searchExact(new TextFragment("source2"), null);
        Assert.assertEquals((long)1L, (long)hits.size());
        hit = (TmHit)hits.get(0);
        Assert.assertEquals((Object)"seg2", (Object)hit.getTu().getMetadataValue(MetadataType.ID));
    }

    @Test
    public void testTmReadWriteExact() {
        TranslationUnit unit1 = new TranslationUnit(new TranslationUnitVariant(LocaleId.ENGLISH, new TextFragment("source1")), new TranslationUnitVariant(LocaleId.GERMAN, new TextFragment("target1")));
        unit1.setMetadataValue(MetadataType.ID, "seg1");
        this.tmWriter.indexTranslationUnit(unit1);
        this.tmWriter.commit();
        List hits = this.currentTm.searchExact(new TextFragment("source1"), null);
        Assert.assertEquals((long)1L, (long)hits.size());
        TmHit hit = (TmHit)hits.get(0);
        Assert.assertEquals((Object)"seg1", (Object)hit.getTu().getMetadataValue(MetadataType.ID));
        TranslationUnit unit2 = new TranslationUnit(new TranslationUnitVariant(LocaleId.ENGLISH, new TextFragment("source2")), new TranslationUnitVariant(LocaleId.GERMAN, new TextFragment("target2")));
        unit2.setMetadataValue(MetadataType.ID, "seg2");
        this.tmWriter.indexTranslationUnit(unit2);
        this.tmWriter.commit();
        this.currentTm.close();
        this.currentTm = TmSeekerFactory.createFileBasedTmSeeker((String)this.tmDir);
        hits = this.currentTm.searchExact(new TextFragment("source1"), null);
        Assert.assertEquals((long)1L, (long)hits.size());
        hit = (TmHit)hits.get(0);
        Assert.assertEquals((Object)"seg1", (Object)hit.getTu().getMetadataValue(MetadataType.ID));
        hits = this.currentTm.searchExact(new TextFragment("source2"), null);
        Assert.assertEquals((long)1L, (long)hits.size());
        hit = (TmHit)hits.get(0);
        Assert.assertEquals((Object)"seg2", (Object)hit.getTu().getMetadataValue(MetadataType.ID));
    }

    @Test
    public void testTmReadWriteFuzzy() {
        TranslationUnit unit1 = new TranslationUnit(new TranslationUnitVariant(LocaleId.ENGLISH, new TextFragment("source1")), new TranslationUnitVariant(LocaleId.GERMAN, new TextFragment("target1")));
        unit1.setMetadataValue(MetadataType.ID, "seg1");
        this.tmWriter.indexTranslationUnit(unit1);
        this.tmWriter.commit();
        List hits = this.currentTm.searchFuzzy(new TextFragment("source1"), 95, 1, null);
        if (hits.size() > 0) {
            TmHit hit = (TmHit)hits.get(0);
            Assert.assertEquals((Object)"seg1", (Object)hit.getTu().getMetadataValue(MetadataType.ID));
        }
        TranslationUnit unit2 = new TranslationUnit(new TranslationUnitVariant(LocaleId.ENGLISH, new TextFragment("source2")), new TranslationUnitVariant(LocaleId.GERMAN, new TextFragment("target2")));
        unit2.setMetadataValue(MetadataType.ID, "seg2");
        this.tmWriter.indexTranslationUnit(unit2);
        this.tmWriter.commit();
        hits = this.currentTm.searchFuzzy(new TextFragment("source2"), 95, 1, null);
        if (hits.size() > 0) {
            TmHit hit = (TmHit)hits.get(0);
            Assert.assertEquals((Object)"seg2", (Object)hit.getTu().getMetadataValue(MetadataType.ID));
        }
    }

    @Test
    public void testTmReadWriteSentenceExact() {
        TranslationUnit unit1 = new TranslationUnit(new TranslationUnitVariant(LocaleId.ENGLISH, new TextFragment("Elephants cannot fly.")), new TranslationUnitVariant(LocaleId.GERMAN, new TextFragment("Elefanten k\u00f6nnen nicht fliegen.")));
        unit1.setMetadataValue(MetadataType.ID, "seg1");
        this.tmWriter.indexTranslationUnit(unit1);
        this.tmWriter.commit();
        List hits = this.currentTm.searchExact(new TextFragment("source1"), null);
        if (hits.size() > 0) {
            TmHit hit = (TmHit)hits.get(0);
            Assert.assertEquals((Object)"seg1", (Object)hit.getTu().getMetadataValue(MetadataType.ID));
        }
        TranslationUnit unit2 = new TranslationUnit(new TranslationUnitVariant(LocaleId.ENGLISH, new TextFragment("Elephants can fly.")), new TranslationUnitVariant(LocaleId.GERMAN, new TextFragment("Elefanten k\u00f6nnen fliegen.")));
        unit2.setMetadataValue(MetadataType.ID, "seg2");
        this.tmWriter.indexTranslationUnit(unit2);
        this.tmWriter.commit();
        hits = this.currentTm.searchExact(new TextFragment("Elephants can fly."), null);
        if (hits.size() > 0) {
            TmHit hit = (TmHit)hits.get(0);
            Assert.assertEquals((Object)"seg2", (Object)hit.getTu().getMetadataValue(MetadataType.ID));
        }
    }

    @Test
    public void testTmReadWriteSentenceTfExact() {
        TextFragment tf = new TextFragment("Elephants cannot fly.");
        TextFragment ttf = new TextFragment("Elefanten k\u00f6nnen nicht fliegen.");
        TranslationUnit unit1 = new TranslationUnit(new TranslationUnitVariant(LocaleId.ENGLISH, tf), new TranslationUnitVariant(LocaleId.GERMAN, ttf));
        unit1.setMetadataValue(MetadataType.ID, "seg1");
        this.tmWriter.indexTranslationUnit(unit1);
        this.tmWriter.commit();
        List hits = this.currentTm.searchExact(tf, null);
        if (hits.size() > 0) {
            TmHit hit = (TmHit)hits.get(0);
            Assert.assertEquals((Object)"seg1", (Object)hit.getTu().getMetadataValue(MetadataType.ID));
        }
    }

    @Test
    public void testTmReadWriteSentenceFuzzy() {
        TranslationUnit unit1 = new TranslationUnit(new TranslationUnitVariant(LocaleId.ENGLISH, new TextFragment("Elephants cannot fly.")), new TranslationUnitVariant(LocaleId.GERMAN, new TextFragment("Elefanten k\u00f6nnen nicht fliegen.")));
        unit1.setMetadataValue(MetadataType.ID, "seg1");
        this.tmWriter.indexTranslationUnit(unit1);
        this.tmWriter.commit();
        List hits = this.currentTm.searchFuzzy(new TextFragment("Elephants cannot fly."), 95, 1, null);
        if (hits.size() > 0) {
            TmHit hit = (TmHit)hits.get(0);
            Assert.assertEquals((Object)"seg1", (Object)hit.getTu().getMetadataValue(MetadataType.ID));
        }
        TranslationUnit unit2 = new TranslationUnit(new TranslationUnitVariant(LocaleId.ENGLISH, new TextFragment("Elephants can fly.")), new TranslationUnitVariant(LocaleId.GERMAN, new TextFragment("Elefanten k\u00f6nnen fliegen.")));
        unit2.setMetadataValue(MetadataType.ID, "seg2");
        this.tmWriter.indexTranslationUnit(unit2);
        this.tmWriter.commit();
        hits = this.currentTm.searchFuzzy(new TextFragment("Elephants can fly."), 95, 1, null);
        if (hits.size() > 0) {
            TmHit hit = (TmHit)hits.get(0);
            Assert.assertEquals((Object)"seg2", (Object)hit.getTu().getMetadataValue(MetadataType.ID));
        }
    }
}

