/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.postprocess;

import java.util.Objects;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.filters.rainbowkit.Manifest;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.steps.rainbowkit.postprocess.Merger;
import net.sf.okapi.steps.rainbowkit.postprocess.Parameters;

@UsingParameters(value=Parameters.class)
public class MergingStep
extends BasePipelineStep {
    public static final String NAME = "Rainbow Translation Kit Merging";
    private Parameters params = new Parameters();
    private Merger merger;
    private IFilterConfigurationMapper fcMapper;
    private LocaleId targetLocale;

    public String getDescription() {
        return "Post-process a Rainbow translation kit. Expects: filter events. Sends back: filter events or raw documents.";
    }

    public String getName() {
        return NAME;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    public IFilterConfigurationMapper getFilterConfigurationMapper() {
        return this.fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    public LocaleId getTargetLocale() {
        return this.targetLocale;
    }

    public Event handleEvent(Event event) {
        if (Objects.requireNonNull(event.getEventType()) == EventType.START_DOCUMENT) {
            return this.handleStartDocument(event);
        }
        if (this.merger != null) {
            return this.merger.handleEvent(event);
        }
        return event;
    }

    protected Event handleStartDocument(Event event) {
        StartDocument sd = event.getStartDocument();
        MergingInfo info = (MergingInfo)sd.getAnnotation(MergingInfo.class);
        if (info == null) {
            throw new OkapiBadFilterInputException("Start document is missing the merging info annotation.");
        }
        Manifest manifest = (Manifest)sd.getAnnotation(Manifest.class);
        if (manifest == null) {
            throw new OkapiBadFilterInputException("Start document is missing the manifest annotation.");
        }
        boolean alwaysForceTargetLocale = "ontram".equals(info.getExtractionType());
        LocaleId targetLocaleToUse = this.params.getForceTargetLocale() || alwaysForceTargetLocale ? this.targetLocale : manifest.getTargetLocale();
        this.merger = new Merger(this.params, this.fcMapper, manifest, targetLocaleToUse);
        return this.merger.startMerging(info, event);
    }

    public Parameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    protected int getErrorCount() {
        if (this.merger != null) {
            return this.merger.getErrorCount();
        }
        return -1;
    }
}

