/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.po;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.filters.po.POWriter;
import net.sf.okapi.filters.po.Parameters;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;

public class POPackageWriter
extends BasePackageWriter {
    private POWriter writer;
    private String rawDocPath;

    public POPackageWriter() {
        super("po");
    }

    @Override
    protected void processStartBatch() {
        this.manifest.setSubDirectories("original", "work", "work", "done", null, null, true);
        this.setTMXInfo(true, null, true, true, false);
        super.processStartBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        this.writer = new POWriter();
        Parameters wparams = this.writer.getParameters();
        wparams.setOutputGeneric(true);
        this.writer.setMode(true, false, true);
        this.writer.setOptions(this.manifest.getTargetLocale(), "UTF-8");
        MergingInfo item = this.manifest.getItem(this.docId);
        this.rawDocPath = this.manifest.getTempSourceDirectory() + item.getRelativeInputPath() + ".po";
        this.writer.setOutput(this.rawDocPath);
        this.writer.handleEvent(event);
    }

    @Override
    protected Event processEndDocument(Event event) {
        this.writer.handleEvent(event);
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.params.getSendOutput()) {
            return super.creatRawDocumentEventSet(this.rawDocPath, "UTF-8", this.manifest.getSourceLocale(), this.manifest.getTargetLocale());
        }
        return event;
    }

    @Override
    protected void processStartSubDocument(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processEndSubDocument(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return;
        }
        this.writer.handleEvent(event);
        this.writeTMXEntries(event.getTextUnit());
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public String getName() {
        return this.getClass().getName();
    }
}

