/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import java.io.File;
import java.net.URI;
import net.sf.okapi.common.FileCompare;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.filters.its.html5.HTML5Filter;
import net.sf.okapi.filters.openoffice.OpenOfficeFilter;
import net.sf.okapi.filters.properties.PropertiesFilter;
import net.sf.okapi.filters.rainbowkit.RainbowKitFilter;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.rainbowkit.creation.ExtractionStep;
import net.sf.okapi.steps.rainbowkit.creation.Parameters;
import net.sf.okapi.steps.rainbowkit.postprocess.MergingStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExtractThenMergeTest {
    private FileLocation root;
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private LocaleId locFR = LocaleId.fromString((String)"fr");

    @Before
    public void setUp() {
        this.root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void testSimpleExtractThenMerge() {
        Assert.assertTrue((boolean)Util.deleteDirectory((File)this.root.out("/xlf2Pack").asFile()));
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(PropertiesFilter.class.getName());
        fcMapper.addConfigurations(OpenOfficeFilter.class.getName());
        fcMapper.addConfigurations(HTML5Filter.class.getName());
        fcMapper.addConfigurations(RainbowKitFilter.class.getName());
        String rootDir = this.root.in("/").toString();
        fcMapper.setCustomConfigurationsDirectory(rootDir);
        fcMapper.updateCustomConfigurations();
        PipelineDriver pdriver = new PipelineDriver();
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        ExtractionStep es = new ExtractionStep();
        String outputDir = this.root.out("/").toString();
        es.getParameters().setPackageDirectory(outputDir);
        pdriver.addStep((IPipelineStep)es);
        Parameters ep = es.getParameters();
        ep.setWriterClass("net.sf.okapi.steps.rainbowkit.xliff.XLIFF2PackageWriter");
        ep.setPackageName("xlf2Pack");
        URI inputURI = this.root.in("/test01.properties").asUri();
        URI outputURI = new File("test01.out.properties").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_properties", outputURI, "UTF-8", this.locEN, this.locFR));
        inputURI = this.root.in("/test02.html").asUri();
        outputURI = new File("test02.out.html").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_itshtml5", outputURI, "UTF-8", this.locEN, this.locFR));
        inputURI = this.root.in("/sub Dir/test01.odt").asUri();
        outputURI = new File("sub Dir/test01.out.odt").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_openoffice", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        File file = this.root.out("/xlf2Pack/work/test01.properties.xlf").asFile();
        Assert.assertTrue((boolean)file.exists());
        file = this.root.out("/xlf2Pack/work/test02.html.xlf").asFile();
        Assert.assertTrue((boolean)file.exists());
        file = this.root.out("/xlf2Pack/work/sub Dir/test01.odt.xlf").asFile();
        Assert.assertTrue((boolean)file.exists());
        this.deleteOutputDir("/xlf2Pack/done");
        pdriver = new PipelineDriver();
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.setOutputDirectory(rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        MergingStep mrgStep = new MergingStep();
        outputDir = this.root.out("/xlf2Pack/done").toString();
        mrgStep.getParameters().setOverrideOutputPath(outputDir);
        pdriver.addStep((IPipelineStep)mrgStep);
        inputURI = this.root.out("/xlf2Pack/manifest.rkm").asUri();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_rainbowkit@noPrompt", null, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        file = this.root.out("/xlf2Pack/done/test01.out.properties").asFile();
        Assert.assertTrue((boolean)file.exists());
        file = this.root.out("/xlf2Pack/done/test02.out.html").asFile();
        Assert.assertTrue((boolean)file.exists());
        file = this.root.out("/xlf2Pack/done/sub Dir/test01.out.odt").asFile();
        Assert.assertTrue((boolean)file.exists());
        FileCompare fc = new FileCompare();
        fc.filesExactlyTheSame(this.root.out("/xlf2Pack/done/test01.out.properties").toString(), this.root.out("/xlf2Pack/original/test01.properties").toString());
    }

    public void deleteOutputDir(String dirname) {
        Util.deleteDirectory((String)this.root.out(dirname).toString(), (boolean)false);
    }
}

