/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.postprocess;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String PRESERVESEGMENTATION = "preserveSegmentation";
    private static final String RETURNRAWDOCUMENT = "returnRawDocument";
    private static final String FORCETARGETLOCALE = "forceTargetLocale";
    private static final String OVERRIDEOUTPUTPATH = "overrideOutputPath";

    public void reset() {
        super.reset();
        this.setPreserveSegmentation(false);
        this.setReturnRawDocument(false);
        this.setForceTargetLocale(false);
        this.setOverrideOutputPath("");
    }

    public boolean getPreserveSegmentation() {
        return this.getBoolean(PRESERVESEGMENTATION);
    }

    public void setPreserveSegmentation(boolean preserveSegmentation) {
        this.setBoolean(PRESERVESEGMENTATION, preserveSegmentation);
    }

    public boolean getReturnRawDocument() {
        return this.getBoolean(RETURNRAWDOCUMENT);
    }

    public void setReturnRawDocument(boolean returnRawDocument) {
        this.setBoolean(RETURNRAWDOCUMENT, returnRawDocument);
    }

    public boolean getForceTargetLocale() {
        return this.getBoolean(FORCETARGETLOCALE);
    }

    public void setForceTargetLocale(boolean forceTargetLocale) {
        this.setBoolean(FORCETARGETLOCALE, forceTargetLocale);
    }

    public String getOverrideOutputPath() {
        return this.getString(OVERRIDEOUTPUTPATH);
    }

    public void setOverrideOutputPath(String overrideOutputPath) {
        this.setString(OVERRIDEOUTPUTPATH, overrideOutputPath);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(PRESERVESEGMENTATION, "Preserve the segmentation for the next steps", null);
        desc.add(RETURNRAWDOCUMENT, "Return raw documents instead of filter events", null);
        desc.add(FORCETARGETLOCALE, "Specify the target locale from the tool instead of the manifest", null);
        desc.add(OVERRIDEOUTPUTPATH, "Override the output path (leave empty to use the path from the manifest)", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Rainbow Translation Kit Merging", true, false);
        desc.addCheckboxPart(paramDesc.get(PRESERVESEGMENTATION));
        desc.addCheckboxPart(paramDesc.get(RETURNRAWDOCUMENT));
        desc.addCheckboxPart(paramDesc.get(FORCETARGETLOCALE));
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(OVERRIDEOUTPUTPATH));
        tip.setAllowEmpty(true);
        return desc;
    }
}

