/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.common;

import java.text.BreakIterator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;

public class WordCounter {
    private final BreakIterator breaker;
    private final boolean replaceApos;

    public WordCounter(LocaleId locId) {
        this.breaker = BreakIterator.getWordInstance(locId.toJavaLocale());
        String lng = locId.getLanguage();
        this.replaceApos = lng.equals("fr") || lng.equals("it");
    }

    public long getWordCount(ITextUnit tu) {
        return this.getWordCount(tu.getSource());
    }

    public long getWordCount(ITextUnit tu, LocaleId trgId) {
        if (!tu.hasTarget(trgId)) {
            return 0L;
        }
        return this.getWordCount(tu.getTarget(trgId));
    }

    public long getWordCount(TextContainer cont) {
        long res = 0L;
        for (Segment seg : cont.getSegments()) {
            res += this.getWordCount(this.prepareFragment(seg.text));
        }
        return res;
    }

    public long getWordCount(Segment seg) {
        return this.getWordCount(this.prepareFragment(seg.text));
    }

    public long getWordCount(TextFragment frag) {
        return this.getWordCount(this.prepareFragment(frag));
    }

    public long getWordCount(String text) {
        if (Util.isEmpty((String)text)) {
            return 0L;
        }
        long res = 0L;
        if (this.replaceApos) {
            text = text.replace('\'', ' ');
            text = text.replace('\u2019', ' ');
        }
        this.breaker.setText(text);
        int start = this.breaker.first();
        int end = this.breaker.next();
        while (end != -1) {
            for (int i = start; i < end; ++i) {
                if (!Character.isLetterOrDigit(text.codePointAt(i))) continue;
                ++res;
                break;
            }
            start = end;
            end = this.breaker.next();
        }
        return res;
    }

    private String prepareFragment(TextFragment tf) {
        String text = tf.getCodedText();
        if (!tf.hasCode()) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        int startPos = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (TextFragment.isMarker((char)text.charAt(i))) {
                if (i > startPos && startPos >= 0) {
                    sb.append(text.substring(startPos, i));
                }
                if (tf.getCode(text.charAt(++i)).getType().equals("lb")) {
                    sb.append('\n');
                }
                startPos = -1;
                continue;
            }
            if (startPos >= 0) continue;
            startPos = i;
        }
        if (startPos < 0 && sb.length() == 0) {
            startPos = 0;
        } else if (startPos > -1 && startPos < text.length()) {
            sb.append(text.substring(startPos));
        }
        return sb.toString();
    }
}

