/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import net.sf.okapi.common.annotation.GlossEntry;
import net.sf.okapi.common.annotation.GlossaryAnnotation;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.glossary.Glossary;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFF2PackageWriter;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFF2Utils;

public class XLIFF2TerminologyPackageWriter
extends XLIFF2PackageWriter {
    public static final String GLS_SEGMENT_REF_PREFIX = "#gls=";

    @Override
    protected Unit toXLIFF2Unit(ITextUnit unit) {
        GlossaryAnnotation glossaryAnnotation;
        Unit xliffUnit = super.toXLIFF2Unit(unit);
        int segmentIndex = 0;
        for (net.sf.okapi.common.resource.Segment segment : unit.getSourceSegments()) {
            glossaryAnnotation = (GlossaryAnnotation)segment.getAnnotation(GlossaryAnnotation.class);
            Segment xliffSegment = xliffUnit.getSegment(segmentIndex);
            this.addGlossaryReferences(xliffSegment, glossaryAnnotation);
            ++segmentIndex;
        }
        for (net.sf.okapi.common.resource.Segment segment : unit.getSourceSegments()) {
            glossaryAnnotation = (GlossaryAnnotation)segment.getAnnotation(GlossaryAnnotation.class);
            this.addGlossary(xliffUnit, glossaryAnnotation);
        }
        return xliffUnit;
    }

    protected void addGlossaryReferences(Segment xliffSegment, GlossaryAnnotation glossaryAnnotation) {
        if (glossaryAnnotation == null) {
            return;
        }
        for (GlossEntry glossEntry : glossaryAnnotation) {
            if (glossaryAnnotation.isAnnotateSourceSegment()) {
                this.annotateTerms(xliffSegment.getSource(), glossEntry.getId(), glossEntry.getTerm().getText());
            }
            if (!glossaryAnnotation.isAnnotateTargetSegment()) continue;
            for (GlossEntry.Translation translation : glossEntry.getTranslations()) {
                this.annotateTerms(xliffSegment.getTarget(), glossEntry.getId(), translation.getText());
            }
        }
    }

    protected void addGlossary(Unit xliffUnit, GlossaryAnnotation glossaryAnnotation) {
        if (glossaryAnnotation == null) {
            return;
        }
        Glossary xliffGlossary = xliffUnit.getGlossary();
        for (GlossEntry glossEntry : glossaryAnnotation) {
            xliffGlossary.add((Object)XLIFF2Utils.toXliffGlossEntry(glossEntry));
        }
    }

    private void annotateTerms(Fragment textFragment, String glossEntryId, String term) {
        int offset = 0;
        String ref = GLS_SEGMENT_REF_PREFIX + glossEntryId;
        while (offset != -1) {
            int start = textFragment.getPlainText().indexOf(term, offset);
            if (start != -1) {
                start = textFragment.getCodedTextPosition(start, false);
                int end = start + term.length();
                textFragment.annotate(start, end, "term", null, ref);
                offset = end;
                continue;
            }
            offset = start;
        }
    }
}

