/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.postprocess;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import net.sf.okapi.common.FileCompare;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.filters.openoffice.OpenOfficeFilter;
import net.sf.okapi.filters.properties.PropertiesFilter;
import net.sf.okapi.filters.rainbowkit.RainbowKitFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.rainbowkit.creation.ExtractionStep;
import net.sf.okapi.steps.rainbowkit.postprocess.MergingStep;
import net.sf.okapi.steps.rainbowkit.postprocess.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MergingStepTest {
    private FileLocation root;
    private FilterConfigurationMapper fcMapper;
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private LocaleId locFR = LocaleId.fromString((String)"fr");

    @Before
    public void setUp() {
        this.root = FileLocation.fromClass(this.getClass());
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations(PropertiesFilter.class.getName());
        this.fcMapper.addConfigurations(OpenOfficeFilter.class.getName());
        this.fcMapper.addConfigurations(RainbowKitFilter.class.getName());
        this.fcMapper.addConfigurations(XLIFFFilter.class.getName());
        this.fcMapper.setCustomConfigurationsDirectory(this.root.in("/").toString());
        this.fcMapper.updateCustomConfigurations();
    }

    @Test
    public void textXLIFFMerging() {
        this.testXLIFFMerging(false);
        this.testXLIFFMerging(true);
    }

    private void testXLIFFMerging(boolean returnRawDoc) {
        this.deleteOutputDir("/xliffPack/done");
        PipelineDriver pdriver = new PipelineDriver();
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)this.fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        MergingStep mrgStep = new MergingStep();
        pdriver.addStep((IPipelineStep)mrgStep);
        Parameters prm = mrgStep.getParameters();
        String outputDir = this.root.out("/xliffPack/done").toString();
        prm.setOverrideOutputPath(outputDir);
        prm.setReturnRawDocument(returnRawDoc);
        URI inputURI = this.root.in("/xliffPack/manifest.rkm").asUri();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_rainbowkit@noPrompt", null, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        Assert.assertTrue((mrgStep.getErrorCount() == 0 ? 1 : 0) != 0);
        File file = this.root.out("/xliffPack/done/test01.out.properties").asFile();
        Assert.assertTrue((boolean)file.exists());
        file = this.root.out("/xliffPack/done/sub Dir/test01.out.odt").asFile();
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void missedCodesInTargetNotAdded() throws IOException {
        this.deleteOutputDir("/xliffPack/done");
        PipelineDriver pdriver = new PipelineDriver();
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)this.fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        MergingStep mrgStep = new MergingStep();
        pdriver.addStep((IPipelineStep)mrgStep);
        Parameters prm = mrgStep.getParameters();
        String outputDir = this.root.out("/xliffPack/done").toString();
        prm.setOverrideOutputPath(outputDir);
        URI inputURI = this.root.in("/xliffPack/manifest.rkm").asUri();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, StandardCharsets.UTF_8.name(), "okf_rainbowkit@noPrompt", null, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        FileLocation.Out fileLocation = this.root.out("/xliffPack/done/test02.out.properties");
        Assert.assertTrue((boolean)fileLocation.asFile().exists());
        Assert.assertEquals((Object)"ID10=Text for ID10 with %s and .", (Object)new String(Files.readAllBytes(fileLocation.asPath()), StandardCharsets.UTF_8.name()).trim());
    }

    @Test
    public void testXLIFFExtractThenMerge() {
        this.deleteOutputDir("/pack1");
        PipelineDriver pdriver = new PipelineDriver();
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)this.fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        ExtractionStep extStep = new ExtractionStep();
        String outputDir = this.root.out("/").toString();
        extStep.getParameters().setPackageDirectory(outputDir);
        pdriver.addStep((IPipelineStep)extStep);
        URI inputURI = this.root.in("/test01.properties").asUri();
        URI outputURI = new File("test01.out.properties").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_properties", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        File file = this.root.out("/pack1/work/test01.properties.xlf").asFile();
        Assert.assertTrue((boolean)file.exists());
        pdriver.clearSteps();
        pdriver.clearItems();
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        MergingStep mrgStep = new MergingStep();
        outputDir = this.root.out("/pack1/done").toString();
        mrgStep.getParameters().setOverrideOutputPath(outputDir);
        pdriver.addStep((IPipelineStep)mrgStep);
        inputURI = this.root.out("/pack1/manifest.rkm").asUri();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_rainbowkit@noPrompt", null, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        Assert.assertTrue((mrgStep.getErrorCount() == 0 ? 1 : 0) != 0);
        file = this.root.out("/pack1/done/test01.out.properties").asFile();
        Assert.assertTrue((boolean)file.exists());
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(file.toString(), this.root.in("/test01.properties").toString(), "us-ascii"));
    }

    @Test
    public void testXINIMerging() {
        this.deleteOutputDir("/xiniPack/translated");
        PipelineDriver pdriver = new PipelineDriver();
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)this.fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        MergingStep mrgStep = new MergingStep();
        String outputDir = this.root.out("/xiniPack/translated").toString();
        mrgStep.getParameters().setOverrideOutputPath(outputDir);
        pdriver.addStep((IPipelineStep)mrgStep);
        Parameters prm = mrgStep.getParameters();
        prm.setReturnRawDocument(true);
        URI inputURI = this.root.in("/xiniPack/manifest.rkm").asUri();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_rainbowkit@noPrompt", null, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        Assert.assertTrue((mrgStep.getErrorCount() == 0 ? 1 : 0) != 0);
        File file = this.root.out("/xiniPack/translated/test1.out.xlf").asFile();
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void testXINIMergingWithOutputPath() {
        this.deleteOutputDir("/xiniPack/translated");
        PipelineDriver pdriver = new PipelineDriver();
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)this.fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        MergingStep mrgStep = new MergingStep();
        String outputDir = this.root.out("/omegatPack/done").toString();
        mrgStep.getParameters().setOverrideOutputPath(outputDir);
        pdriver.addStep((IPipelineStep)mrgStep);
        Parameters prm = mrgStep.getParameters();
        prm.setReturnRawDocument(true);
        prm.setOverrideOutputPath(this.root.out("/output/").toString());
        URI inputURI = this.root.in("/xiniPack/manifest.rkm").asUri();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_rainbowkit@noPrompt", null, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        Assert.assertTrue((mrgStep.getErrorCount() == 0 ? 1 : 0) != 0);
        File file = this.root.out("/output/test1.out.xlf").asFile();
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void testPOMerging() {
        this.deleteOutputDir("/poPack/done");
        PipelineDriver pdriver = new PipelineDriver();
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)this.fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        MergingStep mrgStep = new MergingStep();
        String outputDir = this.root.out("/poPack/done").toString();
        mrgStep.getParameters().setOverrideOutputPath(outputDir);
        pdriver.addStep((IPipelineStep)mrgStep);
        URI inputURI = this.root.in("/poPack/manifest.rkm").asUri();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_rainbowkit@noPrompt", null, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        Assert.assertTrue((mrgStep.getErrorCount() == 0 ? 1 : 0) != 0);
        File file = this.root.out("/poPack/done/test01.out.properties").asFile();
        Assert.assertTrue((boolean)file.exists());
        file = this.root.out("/poPack/done/sub Dir/test01.out.odt").asFile();
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void testOmegaTMerging() {
        this.deleteOutputDir("/omegatPack/done");
        PipelineDriver pdriver = new PipelineDriver();
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)this.fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        MergingStep mrgStep = new MergingStep();
        String outputDir = this.root.out("/omegatPack/done").toString();
        mrgStep.getParameters().setOverrideOutputPath(outputDir);
        pdriver.addStep((IPipelineStep)mrgStep);
        URI inputURI = this.root.in("/omegatPack/manifest.rkm").asUri();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_rainbowkit@noPrompt", null, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        Assert.assertTrue((mrgStep.getErrorCount() == 0 ? 1 : 0) != 0);
        File file = this.root.out("/omegatPack/done/test01.out.properties").asFile();
        Assert.assertTrue((boolean)file.exists());
        file = this.root.out("/omegatPack/done/sub Dir/test01.out.odt").asFile();
        Assert.assertTrue((boolean)file.exists());
    }

    public void deleteOutputDir(String dirname) {
        Util.deleteDirectory((String)this.root.out(dirname).toString(), (boolean)false);
    }
}

