/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.creation;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.steps.rainbowkit.common.WordCounter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WordCounterTest {
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private LocaleId locFR = LocaleId.fromString((String)"FR-CA");

    @Test
    public void testWordCount() {
        WordCounter wc = new WordCounter(this.locEN);
        Assert.assertEquals((long)5L, (long)wc.getWordCount("This is a (simple) test"));
        Assert.assertEquals((long)4L, (long)wc.getWordCount("He is an Italian-American"));
        Assert.assertEquals((long)0L, (long)wc.getWordCount("- \u2010 \u30a0"));
        Assert.assertEquals((long)4L, (long)wc.getWordCount("Born in the U.S.A."));
        Assert.assertEquals((long)6L, (long)wc.getWordCount("The link is: http://okapi.opentag.com/snapshots"));
        wc = new WordCounter(this.locFR);
        Assert.assertEquals((long)4L, (long)wc.getWordCount("L'objectif est atteint."));
        Assert.assertEquals((long)4L, (long)wc.getWordCount("L\u2019objectif est atteint."));
        wc = new WordCounter(LocaleId.RUSSIAN);
        Assert.assertEquals((long)2L, (long)wc.getWordCount("\u042d\u0442\u043e \u0442\u0435\u0441\u0442"));
    }

    @Test
    public void testWordCountFragmentWithInlineCodes() {
        WordCounter wc = new WordCounter(this.locEN);
        TextFragment tf = new TextFragment("Uppercase is ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("old and there are");
        tf.append(TextFragment.TagType.PLACEHOLDER, "lb", "<br/>");
        tf.append("two lines.");
        Assert.assertEquals((long)8L, (long)wc.getWordCount(tf));
    }
}

